/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.config;

public class Option<T> {
    protected final T defaultOption;
    protected T option;

    public Option(T defaultOption) {
        this.defaultOption = defaultOption;
        this.option = defaultOption;
    }

    public T getValue() {
        return this.option;
    }

    public void setValue(T option) {
        this.option = option;
    }

    public void setDefaultValue() {
        this.option = this.defaultOption;
    }

    public static class DoubleOption
    extends Option<Double> {
        private final double minValue;
        private final double maxValue;

        public DoubleOption(Double defaultOption, double minValue, double maxValue) {
            super(defaultOption);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public void setValue(Double option) {
            this.option = option > this.maxValue ? Double.valueOf(this.minValue) : (option < this.minValue ? Double.valueOf(this.maxValue) : option);
        }
    }

    public static class IntegerOption
    extends Option<Integer> {
        private final int minValue;
        private final int maxValue;

        public IntegerOption(Integer defaultOption, int minValue, int maxValue) {
            super(defaultOption);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public void setValue(Integer option) {
            this.option = option > this.maxValue ? Integer.valueOf(this.minValue) : (option < this.minValue ? Integer.valueOf(this.maxValue) : option);
        }
    }
}

