/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import xaero.pac.common.claims.ClaimStateHolder;
import xaero.pac.common.claims.DimensionClaimsManager;
import xaero.pac.common.claims.IClaimsManager;
import xaero.pac.common.claims.RegionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.tracker.ClaimsManagerTracker;
import xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI;
import xaero.pac.common.server.player.config.IPlayerConfigManager;

public abstract class ClaimsManager<PCI extends PlayerClaimInfo<PCI, M>, M extends PlayerClaimInfoManager<PCI, M>, WRC extends RegionClaims<M, WRC>, WCM extends DimensionClaimsManager<M, WRC>, CSH extends ClaimStateHolder>
implements IClaimsManager<PCI, WCM> {
    protected final M playerClaimInfoManager;
    protected final IPlayerConfigManager configManager;
    private Map<ResourceLocation, WCM> dimensions;
    private Int2ObjectMap<PlayerChunkClaim> indexToClaimState;
    protected Map<PlayerChunkClaim, CSH> claimStateHolders;
    private int nextClaimStateSyncIndex;
    protected final ClaimsManagerTracker claimsManagerTracker;

    protected ClaimsManager(M playerClaimInfoManager, IPlayerConfigManager configManager, Map<ResourceLocation, WCM> dimensions, Int2ObjectMap<PlayerChunkClaim> indexToClaimState, Map<PlayerChunkClaim, CSH> claimStates, ClaimsManagerTracker claimsManagerTracker) {
        this.playerClaimInfoManager = playerClaimInfoManager;
        this.configManager = configManager;
        this.dimensions = dimensions;
        this.indexToClaimState = indexToClaimState;
        this.claimStateHolders = claimStates;
        this.claimsManagerTracker = claimsManagerTracker;
    }

    protected abstract CSH createStateHolder(PlayerChunkClaim var1);

    protected void addClaimState(PlayerChunkClaim claim) {
        CSH claimStateHolder = this.createStateHolder(claim);
        this.claimStateHolders.put(claim, claimStateHolder);
        this.indexToClaimState.put(claim.getSyncIndex(), (Object)claim);
        this.onClaimStateAdded(claimStateHolder);
    }

    protected abstract void onClaimStateAdded(CSH var1);

    protected void reset() {
        this.indexToClaimState.clear();
        this.dimensions.clear();
        this.claimStateHolders.clear();
        this.indexToClaimState = new Int2ObjectOpenHashMap();
        this.dimensions = new HashMap<ResourceLocation, WCM>();
        this.claimStateHolders = new HashMap<PlayerChunkClaim, CSH>();
        ((PlayerClaimInfoManager)this.playerClaimInfoManager).clear();
    }

    protected WCM ensureDimension(ResourceLocation dim) {
        return (WCM)this.dimensions.computeIfAbsent(dim, d -> this.create((ResourceLocation)d, (Long2ObjectMap<WRC>)new Long2ObjectOpenHashMap()));
    }

    @Override
    @Nullable
    public WCM getDimension(@Nonnull ResourceLocation dimension) {
        return (WCM)((DimensionClaimsManager)this.dimensions.get(dimension));
    }

    @Override
    @Nonnull
    public Stream<WCM> getDimensionStream() {
        return this.dimensions.values().stream();
    }

    public PlayerChunkClaim getClaimState(UUID id, int subConfigIndex, boolean forceload) {
        PlayerChunkClaim potentialState = new PlayerChunkClaim(id, subConfigIndex, forceload, this.nextClaimStateSyncIndex);
        ClaimStateHolder originalStateHolder = (ClaimStateHolder)this.claimStateHolders.get(potentialState);
        if (originalStateHolder == null) {
            if (this.nextClaimStateSyncIndex == -1) {
                throw new RuntimeException("Somehow managed to run out of claim states");
            }
            ++this.nextClaimStateSyncIndex;
            this.addClaimState(potentialState);
            return potentialState;
        }
        return originalStateHolder.getState();
    }

    protected void removeClaimState(PlayerChunkClaim state) {
        this.claimStateHolders.remove(state);
        this.indexToClaimState.remove(state.getSyncIndex());
    }

    public PlayerChunkClaim getClaimStateBySyncIndex(int syncIndex) {
        return (PlayerChunkClaim)this.indexToClaimState.get(syncIndex);
    }

    public Stream<PlayerChunkClaim> getClaimStatesStream() {
        return this.claimStateHolders.keySet().stream();
    }

    protected abstract WCM create(ResourceLocation var1, Long2ObjectMap<WRC> var2);

    public PlayerChunkClaim claim(ResourceLocation dimension, UUID id, int subConfigIndex, int x, int z, boolean forceload) {
        WCM dimensionClaims = this.ensureDimension(dimension);
        PlayerChunkClaim claim = this.getClaimState(id, subConfigIndex, forceload);
        return ((DimensionClaimsManager)dimensionClaims).claim(x, z, claim, this.playerClaimInfoManager, this.configManager);
    }

    public void unclaim(ResourceLocation dimension, int x, int z) {
        WCM dimensionClaims = this.ensureDimension(dimension);
        ((DimensionClaimsManager)dimensionClaims).unclaim(x, z, this.playerClaimInfoManager, this.configManager);
    }

    @Override
    public boolean hasPlayerInfo(@Nonnull UUID playerId) {
        return ((PlayerClaimInfoManager)this.playerClaimInfoManager).hasInfo(playerId);
    }

    @Override
    @Nonnull
    public PCI getPlayerInfo(@Nonnull UUID playerId) {
        return ((PlayerClaimInfoManager)this.playerClaimInfoManager).getInfo(playerId);
    }

    @Override
    @Nonnull
    public Stream<PCI> getPlayerInfoStream() {
        return ((PlayerClaimInfoManager)this.playerClaimInfoManager).getInfoStream();
    }

    public Iterator<PCI> getPlayerInfoIterator() {
        return ((PlayerClaimInfoManager)this.playerClaimInfoManager).iterator();
    }

    @Override
    @Nullable
    public PlayerChunkClaim get(@Nonnull ResourceLocation dimension, int x, int z) {
        WCM dimensionClaims = this.ensureDimension(dimension);
        return ((DimensionClaimsManager)dimensionClaims).get(x, z);
    }

    @Override
    @Nullable
    public PlayerChunkClaim get(@Nonnull ResourceLocation dimension, @Nonnull ChunkPos chunkPos) {
        return this.get(dimension, chunkPos.f_45578_, chunkPos.f_45579_);
    }

    @Override
    @Nullable
    public PlayerChunkClaim get(@Nonnull ResourceLocation dimension, @Nonnull BlockPos blockPos) {
        return this.get(dimension, blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
    }

    @Override
    @Nonnull
    public ClaimsManagerTracker getTracker() {
        return this.claimsManagerTracker;
    }

    public M getPlayerClaimInfoManager() {
        return this.playerClaimInfoManager;
    }

    public int getClaimStateCount() {
        return this.claimStateHolders.size();
    }

    public static enum Action {
        CLAIM,
        UNCLAIM,
        FORCELOAD,
        UNFORCELOAD;

    }

    public static abstract class Builder<PCI extends PlayerClaimInfo<PCI, M>, M extends PlayerClaimInfoManager<PCI, M>, WRC extends RegionClaims<M, WRC>, WCM extends DimensionClaimsManager<M, WRC>, CSH extends ClaimStateHolder, B extends Builder<PCI, M, WRC, WCM, CSH, B>> {
        protected final B self = this;
        protected M playerClaimInfoManager;
        protected Map<ResourceLocation, WCM> dimensions;
        protected Map<PlayerChunkClaim, CSH> claimStates;

        protected Builder() {
        }

        public B setDefault() {
            this.setPlayerClaimInfoManager(null);
            this.setDimensions(null);
            this.setClaimStates(null);
            return this.self;
        }

        protected B setPlayerClaimInfoManager(M playerClaimInfoManager) {
            this.playerClaimInfoManager = playerClaimInfoManager;
            return this.self;
        }

        public B setDimensions(Map<ResourceLocation, WCM> dimensions) {
            this.dimensions = dimensions;
            return this.self;
        }

        public B setClaimStates(Map<PlayerChunkClaim, CSH> claimStates) {
            this.claimStates = claimStates;
            return this.self;
        }

        public ClaimsManager<PCI, M, WRC, WCM, CSH> build() {
            if (this.playerClaimInfoManager == null) {
                throw new IllegalStateException();
            }
            if (this.dimensions == null) {
                this.dimensions = new HashMap<ResourceLocation, WCM>();
            }
            if (this.claimStates == null) {
                this.claimStates = new HashMap<PlayerChunkClaim, CSH>();
            }
            return this.buildInternally(this.claimStates, new ClaimsManagerTracker(new HashSet<IClaimsManagerListenerAPI>()), (Int2ObjectMap<PlayerChunkClaim>)new Int2ObjectOpenHashMap());
        }

        protected abstract ClaimsManager<PCI, M, WRC, WCM, CSH> buildInternally(Map<PlayerChunkClaim, CSH> var1, ClaimsManagerTracker var2, Int2ObjectMap<PlayerChunkClaim> var3);
    }
}

