/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.player.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.PlayerConfigClientStorageManager;
import xaero.pac.client.player.config.PlayerConfigOptionClientStorage;
import xaero.pac.client.player.config.PlayerConfigStringableOptionClientStorage;
import xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI;
import xaero.pac.client.player.config.sub.PlayerSubConfigClientStorage;
import xaero.pac.common.list.SortedValueList;
import xaero.pac.common.misc.MapFactory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class PlayerConfigClientStorage
implements IPlayerConfigClientStorage<PlayerConfigStringableOptionClientStorage<?>> {
    private final PlayerConfigClientStorageManager manager;
    private final PlayerConfigType type;
    private final UUID owner;
    private final Map<PlayerConfigOptionSpec<?>, PlayerConfigStringableOptionClientStorage<?>> options;
    private final List<String> subConfigIdsUnmodifiable;
    private final SortedValueList<String> subConfigIds;
    private String selectedSubConfig;
    private final Map<String, PlayerSubConfigClientStorage> subConfigs;
    private boolean syncInProgress;
    private boolean beingDeleted;
    private int subConfigLimit;

    protected PlayerConfigClientStorage(PlayerConfigClientStorageManager manager, PlayerConfigType type, UUID owner, Map<PlayerConfigOptionSpec<?>, PlayerConfigStringableOptionClientStorage<?>> options, List<String> subConfigIdsUnmodifiable, SortedValueList<String> subConfigIds, Map<String, PlayerSubConfigClientStorage> subConfigs) {
        this.manager = manager;
        this.type = type;
        this.owner = owner;
        this.options = options;
        this.subConfigIdsUnmodifiable = subConfigIdsUnmodifiable;
        this.subConfigIds = subConfigIds;
        this.subConfigs = subConfigs;
    }

    protected <T extends Comparable<T>> T getDefaultValue(PlayerConfigOptionSpec<T> option) {
        return option.getDefaultValue();
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> PlayerConfigStringableOptionClientStorage<T> getOptionStorage(@Nonnull IPlayerConfigOptionSpecAPI<T> o) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        PlayerConfigOptionClientStorage result = this.options.get(option);
        if (result == null) {
            PlayerConfigStringableOptionClientStorage.Builder builder = PlayerConfigStringableOptionClientStorage.Builder.begin();
            ((PlayerConfigStringableOptionClientStorage.Builder)builder.setOption(option)).setValue(this.getDefaultValue(option));
            result = builder.build();
            this.options.put(option, (PlayerConfigStringableOptionClientStorage<?>)result);
        }
        return result;
    }

    @Override
    @Nonnull
    public PlayerConfigType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public Stream<PlayerConfigStringableOptionClientStorage<?>> optionStream() {
        return this.manager.getAllOptionsStream().map(iPlayerConfigOptionSpecAPI -> this.getOptionStorage((IPlayerConfigOptionSpecAPI)iPlayerConfigOptionSpecAPI));
    }

    public PlayerSubConfigClientStorage getOrCreateSubConfig(String subId) {
        PlayerSubConfigClientStorage result = this.subConfigs.get(subId);
        if (result == null) {
            result = ((PlayerSubConfigClientStorage.Builder)((PlayerSubConfigClientStorage.Builder)((PlayerSubConfigClientStorage.Builder)PlayerSubConfigClientStorage.Builder.begin(LinkedHashMap::new).setSubID(subId).setOwner(this.owner)).setManager(this.manager)).setType(this.type)).build();
            this.subConfigs.put(subId, result);
            this.subConfigIds.add(subId);
        }
        return result;
    }

    @Override
    public void removeSubConfig(String subId) {
        PlayerSubConfigClientStorage removed = this.subConfigs.remove(subId);
        if (removed != null) {
            removed.setBeingDeleted(false);
            this.subConfigIds.remove(subId);
        }
    }

    @Override
    @Nonnull
    public List<String> getSubConfigIds() {
        return this.subConfigIdsUnmodifiable;
    }

    @Override
    @Nullable
    public PlayerSubConfigClientStorage getSubConfig(@Nonnull String id) {
        return this.subConfigs.get(id);
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getEffectiveSubConfig(@Nonnull String id) {
        if ("main".equals(id)) {
            return this;
        }
        PlayerSubConfigClientStorage sub = this.getSubConfig(id);
        return sub == null ? this : sub;
    }

    @Override
    public boolean subConfigExists(@Nonnull String id) {
        return this.subConfigs.containsKey(id);
    }

    @Override
    public int getSubCount() {
        return this.subConfigs.size();
    }

    @Override
    @Nonnull
    public Stream<IPlayerConfigClientStorageAPI<PlayerConfigStringableOptionClientStorage<?>>> getSubConfigAPIStream() {
        return this.getSubConfigStream().map(Function.identity());
    }

    @Override
    public Stream<IPlayerConfigClientStorage<PlayerConfigStringableOptionClientStorage<?>>> getSubConfigStream() {
        return this.subConfigs.values().stream().map(Function.identity());
    }

    @Override
    public void setSelectedSubConfig(String selectedSubConfig) {
        this.selectedSubConfig = selectedSubConfig;
    }

    @Override
    public String getSelectedSubConfig() {
        return this.selectedSubConfig;
    }

    public boolean isSubConfigSelected() {
        return this.selectedSubConfig != null && !this.selectedSubConfig.equals("main") && this.subConfigExists(this.selectedSubConfig);
    }

    @Override
    public void reset() {
        this.options.clear();
        this.selectedSubConfig = null;
        if (this.subConfigs != null) {
            this.subConfigIds.clear();
            this.subConfigIds.add("main");
            this.subConfigs.clear();
            this.syncInProgress = true;
        }
    }

    public String getSubId() {
        return null;
    }

    @Override
    public boolean isSyncInProgress() {
        return this.syncInProgress;
    }

    @Override
    public void setSyncInProgress(boolean syncInProgress) {
        this.syncInProgress = syncInProgress;
    }

    @Override
    public void setGeneralState(boolean beingDeleted, int subConfigLimit) {
        this.beingDeleted = beingDeleted;
        this.subConfigLimit = subConfigLimit;
    }

    @Override
    public boolean isBeingDeleted() {
        return this.beingDeleted;
    }

    public void setBeingDeleted(boolean beingDeleted) {
        this.beingDeleted = beingDeleted;
    }

    @Override
    public int getSubConfigLimit() {
        if (this.type == PlayerConfigType.SERVER) {
            return Integer.MAX_VALUE;
        }
        return this.subConfigLimit;
    }

    public static abstract class Builder<B extends Builder<B>>
    implements IPlayerConfigClientStorage.IBuilder<PlayerConfigClientStorage> {
        protected final B self = this;
        protected PlayerConfigType type;
        protected UUID owner;
        protected PlayerConfigClientStorageManager manager;
        protected final MapFactory mapFactory;

        protected Builder(MapFactory mapFactory) {
            this.mapFactory = mapFactory;
        }

        public B setDefault() {
            this.setOwner(null);
            this.setType(null);
            this.setManager(null);
            return this.self;
        }

        public B setType(PlayerConfigType type) {
            this.type = type;
            return this.self;
        }

        public B setOwner(UUID owner) {
            this.owner = owner;
            return this.self;
        }

        public B setManager(PlayerConfigClientStorageManager manager) {
            this.manager = manager;
            return this.self;
        }

        @Override
        public PlayerConfigClientStorage build() {
            if (this.type == null || this.manager == null) {
                throw new IllegalStateException();
            }
            Map<PlayerConfigOptionSpec<?>, PlayerConfigStringableOptionClientStorage<?>> options = this.mapFactory.get();
            return this.buildInternally(options);
        }

        protected abstract PlayerConfigClientStorage buildInternally(Map<PlayerConfigOptionSpec<?>, PlayerConfigStringableOptionClientStorage<?>> var1);
    }

    public static final class FinalBuilder
    extends Builder<FinalBuilder> {
        private FinalBuilder(MapFactory mapFactory) {
            super(mapFactory);
        }

        @Override
        protected PlayerConfigClientStorage buildInternally(Map<PlayerConfigOptionSpec<?>, PlayerConfigStringableOptionClientStorage<?>> options) {
            ArrayList subConfigIdsStorage = Lists.newArrayList((Object[])new String[]{"main"});
            List<String> subConfigIdsUnmodifiable = Collections.unmodifiableList(subConfigIdsStorage);
            SortedValueList<String> subConfigIds = SortedValueList.Builder.begin().setContent(subConfigIdsStorage).build();
            return new PlayerConfigClientStorage(this.manager, this.type, this.owner, options, subConfigIdsUnmodifiable, subConfigIds, this.mapFactory.get());
        }

        public static FinalBuilder begin(MapFactory mapFactory) {
            return (FinalBuilder)new FinalBuilder(mapFactory).setDefault();
        }
    }
}

