/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.gui.DropdownWidgetListElement;
import xaero.pac.client.gui.OtherPlayerConfigWaitScreen;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.SimpleWidgetListElement;
import xaero.pac.client.gui.TextWidgetListElement;
import xaero.pac.client.gui.WidgetListElement;
import xaero.pac.client.gui.WidgetListScreen;
import xaero.pac.client.gui.widget.value.BooleanValueHolder;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.client.player.config.PlayerConfigOptionClientStorage;
import xaero.pac.client.player.config.PlayerConfigStringableOptionClientStorage;
import xaero.pac.client.player.config.api.IPlayerConfigStringableOptionClientStorageAPI;
import xaero.pac.client.player.config.sub.PlayerSubConfigClientStorage;
import xaero.pac.common.misc.ListFactory;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigHexOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStaticListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStringOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public final class PlayerConfigScreen
extends WidgetListScreen {
    private static final Object NULL_PLACEHOLDER = new Comparable<Object>(){

        @Override
        public int compareTo(@Nonnull Object o) {
            return 0;
        }
    };
    public static final Component SYNCING_IN_PROGRESS = Component.m_237115_((String)"gui.xaero_pac_ui_player_config_syncing");
    public static final Component BEING_DELETED = Component.m_237115_((String)"gui.xaero_pac_ui_player_config_being_deleted");
    private final BiConsumer<PlayerConfigScreen, Button> refreshHandler;
    private Button refreshButton;
    private final PlayerConfigClientStorage data;
    private final PlayerConfigClientStorage optionValueSourceData;
    private final boolean shouldWaitForData;
    private final boolean beingDeletedStateOnOpen;

    private PlayerConfigScreen(List<WidgetListElement<?>> elements, List<EditBox> tickableBoxes, BiConsumer<PlayerConfigScreen, Button> refreshHandler, Screen escape, Screen parent, Component title, PlayerConfigClientStorage data, PlayerConfigClientStorage optionValueSourceData, boolean shouldWaitForData, boolean beingDeletedStateOnOpen) {
        super(elements, tickableBoxes, escape, parent, title);
        this.refreshHandler = refreshHandler;
        this.data = data;
        this.optionValueSourceData = optionValueSourceData;
        this.shouldWaitForData = shouldWaitForData;
        this.beingDeletedStateOnOpen = beingDeletedStateOnOpen;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.refreshButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_pac_ui_player_config_refresh"), b -> this.refreshHandler.accept(this, b)).m_252987_(5, 5, 60, 20).m_253136_();
        this.m_142416_(this.refreshButton);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
    }

    @Override
    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        if (this.shouldWaitForData) {
            if (!this.data.isSyncInProgress()) {
                this.refreshButton.m_5691_();
            } else {
                guiGraphics.m_280653_(this.f_96547_, SYNCING_IN_PROGRESS, this.f_96543_ / 2, this.f_96544_ / 6 + 64, -1);
            }
        }
        if (this.beingDeletedStateOnOpen != this.optionValueSourceData.isBeingDeleted()) {
            this.refreshButton.m_5691_();
        } else if (this.optionValueSourceData.isBeingDeleted()) {
            guiGraphics.m_280653_(this.f_96547_, BEING_DELETED, this.f_96543_ / 2, this.f_96544_ / 6 + 64, -1);
        }
    }

    public static MutableComponent getUICommentForOption(IPlayerConfigOptionSpecAPI<?> option) {
        Object commentTranslated = I18n.m_118938_((String)option.getCommentTranslation(), (Object[])option.getCommentTranslationArgs());
        if (((String)commentTranslated).equals("default")) {
            commentTranslated = option.getComment();
        }
        if (option.getTooltipPrefix() != null) {
            commentTranslated = option.getTooltipPrefix() + "\n" + (String)commentTranslated;
        }
        return Component.m_237113_((String)commentTranslated);
    }

    public static final class Builder {
        private final ListFactory listFactory;
        private IPlayerConfigClientStorageManager<?> manager;
        private PlayerConfigClientStorage data;
        private PlayerConfigClientStorage defaultPlayerConfigData;
        private PlayerConfigClientStorage mainPlayerConfigData;
        private Screen escape;
        private Screen parent;
        private Component title;
        private String otherPlayerName;

        private Builder(ListFactory listFactory) {
            this.listFactory = listFactory;
        }

        public Builder setDefault() {
            this.setManager(null);
            this.setEscape(null);
            this.setParent(null);
            this.setData(null);
            this.setTitle(null);
            this.setMainPlayerConfigData(null);
            return this;
        }

        public Builder setManager(IPlayerConfigClientStorageManager<?> manager) {
            this.manager = manager;
            return this;
        }

        public Builder setData(PlayerConfigClientStorage data) {
            this.data = data;
            return this;
        }

        public Builder setDefaultPlayerConfigData(PlayerConfigClientStorage defaultPlayerConfigData) {
            this.defaultPlayerConfigData = defaultPlayerConfigData;
            return this;
        }

        public Builder setMainPlayerConfigData(PlayerConfigClientStorage mainPlayerConfigData) {
            this.mainPlayerConfigData = mainPlayerConfigData;
            return this;
        }

        public Builder setEscape(Screen escape) {
            this.escape = escape;
            return this;
        }

        public Builder setParent(Screen parent) {
            this.parent = parent;
            return this;
        }

        public Builder setTitle(Component title) {
            this.title = title;
            return this;
        }

        public Builder setOtherPlayerName(String otherPlayerName) {
            this.otherPlayerName = otherPlayerName;
            return this;
        }

        private <T extends Comparable<T>> T getOptionValue(PlayerConfigStringableOptionClientStorage<T> option) {
            Object value = option.isDefaulted() && this.data.getType() == PlayerConfigType.PLAYER ? ((PlayerConfigOptionClientStorage)((Object)this.defaultPlayerConfigData.getOptionStorage(option.getOption()))).getValue() : option.getValue();
            return value;
        }

        private <HT, T extends Comparable<T>> CycleButton.OnValueChange<HT> getRegularValueChangeListener(SimpleValueWidgetListElement.Final<T> el, PlayerConfigStringableOptionClientStorage<T> option, Function<HT, T> holderToValue, PlayerConfigClientStorage data) {
            return (b, vh) -> {
                if (!option.isMutable()) {
                    return;
                }
                Comparable v = (Comparable)holderToValue.apply(vh);
                if (v == NULL_PLACEHOLDER) {
                    v = null;
                }
                el.setDraftValue(v);
                option.setCastValue(v);
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigClientSynchronizer().syncToServer(data, option);
            };
        }

        private <HT, T extends Comparable<T>> BiFunction<SimpleValueWidgetListElement.Final<T>, Vec3i, AbstractWidget> getIterationWidgetSupplierForValues(List<HT> values, PlayerConfigStringableOptionClientStorage<T> option, int elementWidth, int elementHeight, Component optionTitle, Function<T, HT> valueToHolder, Function<HT, T> holderToValue, PlayerConfigClientStorage data) {
            return (el, xy) -> CycleButton.m_168894_(v -> {
                String translationKey;
                String translatedText;
                Component defaultDisplay = ((PlayerConfigOptionSpec)option.getOption()).getValueDisplayName(holderToValue.apply(v));
                if (option.getType() == Integer.class && !(translatedText = I18n.m_118938_((String)(translationKey = option.getTranslation() + "_" + defaultDisplay.getString()), (Object[])new Object[0])).equals("default") && !translatedText.equals(translationKey)) {
                    return Component.m_237115_((String)translationKey).m_6270_(defaultDisplay.m_7383_());
                }
                return defaultDisplay;
            }).m_232502_((Collection)values).m_168948_(valueToHolder.apply(this.getOptionValue(option))).m_168936_(xy.m_123341_(), xy.m_123342_(), elementWidth, elementHeight, optionTitle, this.getRegularValueChangeListener((SimpleValueWidgetListElement.Final)el, option, holderToValue, data));
        }

        private <T extends Comparable<T>> BiFunction<SimpleValueWidgetListElement.Final<T>, Vec3i, AbstractWidget> getIterationWidgetSupplier(PlayerConfigStringableOptionClientStorage<T> option, int elementWidth, int elementHeight, Component optionTitle, T currentValue, PlayerConfigClientStorage data) {
            List<Object> values;
            PlayerConfigClientStorage valueSourceConfig = option.isDefaulted() && data.getType() == PlayerConfigType.PLAYER ? this.defaultPlayerConfigData : data;
            IPlayerConfigOptionSpecAPI iPlayerConfigOptionSpecAPI = option.getOption();
            if (iPlayerConfigOptionSpecAPI instanceof PlayerConfigListIterationOptionSpec) {
                PlayerConfigListIterationOptionSpec listIterationOptionSpec = (PlayerConfigListIterationOptionSpec)iPlayerConfigOptionSpecAPI;
                values = listIterationOptionSpec.getClientSideListGetter().apply(valueSourceConfig);
                if (values == null) {
                    values = Lists.newArrayList((Object[])new Comparable[]{currentValue});
                } else if (data.getType() != PlayerConfigType.PLAYER && data.getType() != PlayerConfigType.DEFAULT_PLAYER) {
                    PlayerConfigStaticListIterationOptionSpec iterationOptionSpec;
                    IPlayerConfigOptionSpecAPI iPlayerConfigOptionSpecAPI2;
                    boolean staticProtectionLevelOption;
                    boolean bl = staticProtectionLevelOption = !option.isDynamic() && (iPlayerConfigOptionSpecAPI2 = option.getOption()) instanceof PlayerConfigStaticListIterationOptionSpec && (iterationOptionSpec = (PlayerConfigStaticListIterationOptionSpec)iPlayerConfigOptionSpecAPI2).getList() == PlayerConfig.PROTECTION_LEVELS;
                    if (staticProtectionLevelOption || option.isDynamic()) {
                        boolean enablesProtection = (staticProtectionLevelOption || option.getId().contains(".barrier.")) && option.getOption() != PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT;
                        values = Lists.newArrayList((Object[])new Comparable[]{(Comparable)values.get(0), (Comparable)values.get(enablesProtection ? 1 : values.size() - 1)});
                    }
                } else {
                    values = Lists.newArrayList((Iterable)values);
                }
            } else {
                values = Lists.newArrayList((Object[])new Comparable[]{currentValue});
            }
            Comparable nullPlaceholder = (Comparable)NULL_PLACEHOLDER;
            if (data instanceof PlayerSubConfigClientStorage) {
                values.add(0, nullPlaceholder);
            }
            return this.getIterationWidgetSupplierForValues(values, option, elementWidth, elementHeight, optionTitle, v -> v == null ? nullPlaceholder : v, h -> h == NULL_PLACEHOLDER ? null : h, data);
        }

        private BiFunction<SimpleValueWidgetListElement.Final<Boolean>, Vec3i, AbstractWidget> getOnOffWidgetSupplier(PlayerConfigStringableOptionClientStorage<Boolean> option, int elementWidth, int elementHeight, Component optionTitle, BooleanValueHolder currentValue, PlayerConfigClientStorage data) {
            ArrayList values = Lists.newArrayList((Object[])new BooleanValueHolder[]{BooleanValueHolder.FALSE, BooleanValueHolder.TRUE});
            if (data instanceof PlayerSubConfigClientStorage) {
                values.add(0, BooleanValueHolder.NULL);
            }
            return this.getIterationWidgetSupplierForValues(values, option, elementWidth, elementHeight, optionTitle, BooleanValueHolder::of, BooleanValueHolder::getValue, data);
        }

        private <T extends Comparable<T>> SimpleValueWidgetListElement<T, ?> createIterationWidgetListElement(PlayerConfigStringableOptionClientStorage<T> option, int elementWidth, int elementHeight, Component optionTitle, List<FormattedCharSequence> tooltip, PlayerConfigClientStorage data) {
            T value = this.getOptionValue(option);
            BiFunction<SimpleValueWidgetListElement.Final<T>, Vec3i, AbstractWidget> widgetSupplier = this.getIterationWidgetSupplier(option, elementWidth, elementHeight, optionTitle, value, data);
            return ((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)SimpleValueWidgetListElement.FinalBuilder.begin().setW(elementWidth)).setH(elementHeight)).setWidgetSupplier(widgetSupplier)).setTooltip(tooltip)).setMutable(option.isMutable())).setStartValue(value)).build();
        }

        private SimpleValueWidgetListElement<Boolean, ?> createOnOffWidgetListElement(PlayerConfigStringableOptionClientStorage<Boolean> option, int elementWidth, int elementHeight, Component optionTitle, List<FormattedCharSequence> tooltip, PlayerConfigClientStorage data) {
            Boolean value = this.getOptionValue(option);
            BiFunction<SimpleValueWidgetListElement.Final<Boolean>, Vec3i, AbstractWidget> widgetSupplier = this.getOnOffWidgetSupplier(option, elementWidth, elementHeight, optionTitle, BooleanValueHolder.of(value), data);
            return ((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)((SimpleValueWidgetListElement.FinalBuilder)SimpleValueWidgetListElement.FinalBuilder.begin().setW(elementWidth)).setH(elementHeight)).setWidgetSupplier(widgetSupplier)).setTooltip(tooltip)).setMutable(option.isMutable())).setStartValue(value)).build();
        }

        private WidgetListElement<?> createSubConfigWidgetListElement(int elementWidth, int elementHeight, List<String> subConfigs, int indexOfSelected) {
            List tooltip = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"gui.xaero_pac_ui_sub_config_dropdown_tooltip"), 200);
            return ((DropdownWidgetListElement.Builder)((DropdownWidgetListElement.Builder)((DropdownWidgetListElement.Builder)((DropdownWidgetListElement.Builder)DropdownWidgetListElement.Builder.begin().setW(elementWidth)).setH(elementHeight)).setTooltip(tooltip)).setMutable(true)).setOptions(subConfigs).setStartIndex(indexOfSelected).setTitle((Component)Component.m_237115_((String)"gui.xaero_pac_ui_sub_config_dropdown")).setValueChangeConsumer(v -> {
                this.data.setSelectedSubConfig((String)v);
                PlayerConfigScreen recreatedScreen = this.build();
                Minecraft.m_91087_().m_91152_((Screen)recreatedScreen);
                recreatedScreen.m_7522_((GuiEventListener)recreatedScreen.m_6702_().get(0));
            }).build();
        }

        private void addSubConfigControls(List<WidgetListElement<?>> elements, int elementWidth, int elementHeight) {
            IPlayerConfigStringableOptionClientStorageAPI usedSubConfigOptionStorage;
            PlayerConfigClientStorage usedSubConfigSyncDest;
            Minecraft minecraft = Minecraft.m_91087_();
            List<String> subConfigs = this.data.getSubConfigIds();
            if (subConfigs.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.data.getType() == PlayerConfigType.SERVER) {
                usedSubConfigSyncDest = this.mainPlayerConfigData;
                usedSubConfigOptionStorage = this.mainPlayerConfigData.getOptionStorage((IPlayerConfigOptionSpecAPI)PlayerConfigOptions.USED_SERVER_SUBCLAIM);
            } else {
                usedSubConfigSyncDest = this.data;
                usedSubConfigOptionStorage = this.data.getOptionStorage((IPlayerConfigOptionSpecAPI)PlayerConfigOptions.USED_SUBCLAIM);
            }
            String selected = this.data.getSelectedSubConfig();
            int indexOfSelectedSub = -1;
            if (selected != null) {
                indexOfSelectedSub = subConfigs.indexOf(selected);
            }
            if (indexOfSelectedSub < 0) {
                indexOfSelectedSub = subConfigs.indexOf(((PlayerConfigOptionClientStorage)((Object)usedSubConfigOptionStorage)).getValue());
            }
            if (indexOfSelectedSub < 0) {
                indexOfSelectedSub = subConfigs.indexOf("main");
            }
            if (indexOfSelectedSub < 0) {
                indexOfSelectedSub = 0;
            }
            this.data.setSelectedSubConfig(subConfigs.get(indexOfSelectedSub));
            PlayerConfigClientStorage subData = this.data.isSubConfigSelected() ? this.data.getOrCreateSubConfig(this.data.getSelectedSubConfig()) : this.data;
            elements.add(this.createSubConfigWidgetListElement(elementWidth, elementHeight, subConfigs, indexOfSelectedSub));
            boolean isCurrentlyUsed = Objects.equals(((PlayerConfigOptionClientStorage)((Object)usedSubConfigOptionStorage)).getValue(), this.data.getSelectedSubConfig());
            boolean canCreateSubs = this.data.getType() == PlayerConfigType.PLAYER || minecraft.f_91074_.m_20310_(2);
            Object useSubConfigButtonWidget = ((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)SimpleWidgetListElement.Builder.begin().setW(elementWidth)).setH(elementHeight)).setMutable(!isCurrentlyUsed && !subData.isBeingDeleted())).setTooltip(minecraft.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)(isCurrentlyUsed ? "gui.xaero_pac_ui_sub_config_use_button_used_tooltip" : "gui.xaero_pac_ui_sub_config_use_button_tooltip")), 200))).setWidgetSupplier((arg_0, arg_1) -> this.lambda$addSubConfigControls$7(isCurrentlyUsed, (PlayerConfigStringableOptionClientStorage)usedSubConfigOptionStorage, usedSubConfigSyncDest, minecraft, elementWidth, elementHeight, arg_0, arg_1))).build();
            elements.add((WidgetListElement<?>)useSubConfigButtonWidget);
            Object deleteSubConfigButtonWidget = ((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)((SimpleWidgetListElement.Builder)SimpleWidgetListElement.Builder.begin().setW(elementWidth)).setH(elementHeight)).setMutable(canCreateSubs && this.data.isSubConfigSelected() && !subData.isBeingDeleted())).setWidgetSupplier((el, xy) -> Button.m_253074_((Component)Component.m_237110_((String)"gui.xaero_pac_ui_sub_config_delete_button", (Object[])new Object[]{this.data.getSelectedSubConfig()}), b -> {
                String s = this.data.getSelectedSubConfig();
                minecraft.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        this.data.getOrCreateSubConfig(s).setBeingDeleted(true);
                        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigClientSynchronizer().requestDeleteSubConfig(this.data, s);
                    }
                    minecraft.m_91152_((Screen)this.build());
                }, (Component)Component.m_237110_((String)"gui.xaero_pac_ui_sub_config_delete_button_confirm1", (Object[])new Object[]{s}), (Component)Component.m_237115_((String)"gui.xaero_pac_ui_sub_config_delete_button_confirm2")));
            }).m_252987_(xy.m_123341_(), xy.m_123342_(), elementWidth, elementHeight).m_253136_())).build();
            elements.add((WidgetListElement<?>)deleteSubConfigButtonWidget);
            TextWidgetListElement createSubConfigWidget = ((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)TextWidgetListElement.Builder.begin().setW(elementWidth)).setH(elementHeight)).setTitle((Component)Component.m_237115_((String)"gui.xaero_pac_ui_sub_config_create_widget")).setTooltip(minecraft.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.xaero_pac_ui_sub_config_create_widget_tooltip", (Object[])new Object[]{Component.m_237110_((String)"gui.xaero_pac_config_create_sub_id_rules", (Object[])new Object[]{16})}), 200))).setMutable(canCreateSubs && this.data.getSubCount() < this.data.getSubConfigLimit())).setStartValue("")).setFilter(Objects::nonNull).setValidator(arg_0 -> this.lambda$addSubConfigControls$11((PlayerConfigStringableOptionClientStorage)usedSubConfigOptionStorage, arg_0)).setResponder((el, s) -> {
                this.data.setSyncInProgress(true);
                this.data.setSelectedSubConfig((String)s);
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigClientSynchronizer().requestCreateSubConfig(this.data, (String)s);
                minecraft.m_91152_((Screen)this.build());
            }).setMaxLength(16).setBoxWidth(75).build();
            elements.add(createSubConfigWidget);
        }

        public PlayerConfigScreen build() {
            boolean subConfigSelected;
            boolean anotherPlayer;
            if (this.manager == null || this.data == null || this.data.getType() == PlayerConfigType.PLAYER && this.defaultPlayerConfigData == null || this.data.getType() == PlayerConfigType.SERVER && this.mainPlayerConfigData == null) {
                throw new IllegalStateException();
            }
            boolean bl = anotherPlayer = this.data.getType() == PlayerConfigType.PLAYER && this.data.getOwner() != null;
            if (anotherPlayer && this.otherPlayerName == null) {
                throw new IllegalStateException();
            }
            List<WidgetListElement<?>> elements = this.listFactory.get();
            int elementWidth = 200;
            int elementHeight = 20;
            BiConsumer<PlayerConfigScreen, Button> refreshHandler = anotherPlayer ? (s, b) -> ((PlayerConfigScreen)s).f_96541_.m_91152_((Screen)new OtherPlayerConfigWaitScreen(s.escape, s.parent, this.otherPlayerName)) : (s, b) -> ((PlayerConfigScreen)s).f_96541_.m_91152_((Screen)this.build());
            Component title = this.title;
            boolean syncInProgress = this.data.isSyncInProgress();
            if (!(syncInProgress || this.data.getType() != PlayerConfigType.PLAYER && this.data.getType() != PlayerConfigType.SERVER)) {
                this.addSubConfigControls(elements, elementWidth, elementHeight);
                if (title == null) {
                    title = this.data.getType() == PlayerConfigType.PLAYER ? Component.m_237110_((String)"gui.xaero_pac_ui_my_player_config_sub", (Object[])new Object[]{this.data.getSelectedSubConfig()}) : Component.m_237110_((String)"gui.xaero_pac_ui_server_claims_config_sub", (Object[])new Object[]{this.data.getSelectedSubConfig()});
                }
            }
            if (title == null) {
                title = Component.m_237115_((String)"gui.xaero_pac_ui_player_config");
            }
            PlayerConfigClientStorage optionValueSourceData = (subConfigSelected = this.data.isSubConfigSelected()) ? this.data.getOrCreateSubConfig(this.data.getSelectedSubConfig()) : this.data;
            Stream<PlayerConfigStringableOptionClientStorage> optionStream = syncInProgress || optionValueSourceData.isBeingDeleted() ? Stream.empty() : optionValueSourceData.optionStream();
            optionStream.forEach(optionStorage -> {
                if (!((PlayerConfigOptionSpec)optionStorage.getOption()).getConfigTypeFilter().test(optionValueSourceData.getType()) || optionStorage.getOption() == PlayerConfigOptions.USED_SUBCLAIM || optionStorage.getOption() == PlayerConfigOptions.USED_SERVER_SUBCLAIM) {
                    return;
                }
                if (optionValueSourceData instanceof PlayerSubConfigClientStorage && !this.manager.getOverridableOptions().contains(optionStorage.getOption())) {
                    return;
                }
                Class type = optionStorage.getType();
                MutableComponent optionTitle = Component.m_237110_((String)optionStorage.getTranslation(), (Object[])optionStorage.getTranslationArgs());
                List tooltip = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)PlayerConfigScreen.getUICommentForOption(optionStorage.getOption()), 200);
                if (type == Boolean.class) {
                    PlayerConfigStringableOptionClientStorage booleanOption = optionStorage;
                    elements.add(this.createOnOffWidgetListElement(booleanOption, elementWidth, elementHeight, (Component)optionTitle, tooltip, optionValueSourceData));
                } else if (optionStorage.getOption() instanceof PlayerConfigListIterationOptionSpec) {
                    elements.add(this.createIterationWidgetListElement((PlayerConfigStringableOptionClientStorage)optionStorage, elementWidth, elementHeight, (Component)optionTitle, tooltip, optionValueSourceData));
                } else {
                    Object value = this.getOptionValue((PlayerConfigStringableOptionClientStorage)optionStorage);
                    Predicate<String> filter = Objects::nonNull;
                    if (type == Integer.class) {
                        filter = optionStorage.getOption() instanceof PlayerConfigHexOptionSpec ? s -> s != null && s.matches("^[0-9A-Fa-f]*$") : s -> s != null && s.matches("^[-0-9]*$");
                    } else if (type == Double.class || type == Float.class) {
                        filter = s -> s != null && s.matches("^[-\\.0-9]*$");
                    }
                    TextWidgetListElement.Builder elementBuilder = ((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)((TextWidgetListElement.Builder)TextWidgetListElement.Builder.begin().setW(elementWidth)).setH(elementHeight)).setTitle((Component)optionTitle).setTooltip(tooltip)).setMutable(optionStorage.isMutable())).setStartValue(value == null ? "" : optionStorage.getCommandOutputWriterCast().apply(value).getString())).setFilter(filter).setValidator(s -> subConfigSelected && s.isEmpty() || optionStorage.getStringValidator().test(optionValueSourceData, (String)s)).setResponder((el, s) -> {
                        if (!optionStorage.isMutable()) {
                            return;
                        }
                        Object newValue = subConfigSelected && s.isEmpty() ? null : optionStorage.getCommandInputParser().apply((String)s);
                        optionStorage.setCastValue(newValue);
                        OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigClientSynchronizer().syncToServer(optionValueSourceData, optionStorage);
                    });
                    if (optionStorage.getOption() instanceof PlayerConfigStringOptionSpec) {
                        elementBuilder.setMaxLength(((PlayerConfigStringOptionSpec)optionStorage.getOption()).getMaxLength());
                    } else if (optionStorage.getOption() instanceof PlayerConfigHexOptionSpec) {
                        elementBuilder.setMaxLength(8);
                    }
                    elements.add(elementBuilder.build());
                }
            });
            return new PlayerConfigScreen(elements, this.listFactory.get(), refreshHandler, this.escape, this.parent, title, this.data, optionValueSourceData, syncInProgress, optionValueSourceData.isBeingDeleted());
        }

        public static Builder begin(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }

        private /* synthetic */ boolean lambda$addSubConfigControls$11(PlayerConfigStringableOptionClientStorage usedSubConfigOptionStorage, String s) {
            return PlayerConfig.isValidSubId(s) && !usedSubConfigOptionStorage.getValidator().test(this.data, (PlayerConfigClientStorage)((Object)s));
        }

        private /* synthetic */ AbstractWidget lambda$addSubConfigControls$7(boolean isCurrentlyUsed, PlayerConfigStringableOptionClientStorage usedSubConfigOptionStorage, PlayerConfigClientStorage usedSubConfigSyncDest, Minecraft minecraft, int elementWidth, int elementHeight, SimpleWidgetListElement el, Vec3i xy) {
            return Button.m_253074_((Component)(isCurrentlyUsed ? Component.m_237115_((String)"gui.xaero_pac_ui_sub_config_use_button_used") : Component.m_237110_((String)"gui.xaero_pac_ui_sub_config_use_button", (Object[])new Object[]{this.data.getSelectedSubConfig()})), b -> {
                usedSubConfigOptionStorage.setValue(this.data.getSelectedSubConfig());
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getPlayerConfigClientSynchronizer().syncToServer(usedSubConfigSyncDest, usedSubConfigOptionStorage);
                minecraft.m_91152_((Screen)this.build());
            }).m_252987_(xy.m_123341_(), xy.m_123342_(), elementWidth, elementHeight).m_253136_();
        }
    }
}

