/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.network.MessageToClientUpdateMerchantScreen;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageMerchantTravel
implements Message<MessageMerchantTravel> {
    private UUID worker;
    private boolean travel;
    private boolean returning;

    public MessageMerchantTravel() {
    }

    public MessageMerchantTravel(UUID recruit, boolean travel, boolean returning) {
        this.worker = recruit;
        this.travel = travel;
        this.returning = returning;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        player.m_20193_().m_6443_(MerchantEntity.class, player.m_20191_().m_82400_(100.0), v -> v.m_20148_().equals(this.worker)).stream().filter(LivingEntity::m_6084_).findAny().ifPresent(merchant -> this.setTraveling(player, (MerchantEntity)merchant, this.travel, this.returning));
    }

    private void setTraveling(ServerPlayer player, MerchantEntity merchant, boolean travel, boolean returning) {
        if (!returning) {
            merchant.setFollow(false);
            merchant.setCurrentWayPointIndex(0);
            if (travel) {
                merchant.setIsWorking(true, true);
                merchant.setCurrentReturningTime(0);
                merchant.tellPlayer((LivingEntity)player, (Component)Component.m_237113_((String)"Im now traveling."));
            } else {
                merchant.setIsWorking(false, true);
                merchant.setReturning(false);
                merchant.setCurrentReturningTime(0);
                merchant.tellPlayer((LivingEntity)player, (Component)Component.m_237113_((String)"I stopped traveling."));
            }
            merchant.setTraveling(travel);
        } else {
            merchant.setIsWorking(true, true);
            merchant.setReturning(true);
            merchant.setTraveling(true);
            merchant.setFollow(false);
            merchant.setCurrentWayPointIndex(merchant.WAYPOINTS.size() - 1);
            merchant.tellPlayer((LivingEntity)player, (Component)Component.m_237113_((String)"Im now returning to start position."));
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateMerchantScreen(merchant.WAYPOINTS, merchant.WAYPOINT_ITEMS, merchant.getCurrentTrades(), merchant.getTradeLimits(), merchant.getTraveling(), merchant.getReturning()));
    }

    @Override
    public MessageMerchantTravel fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        this.travel = buf.readBoolean();
        this.returning = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
        buf.writeBoolean(this.travel);
        buf.writeBoolean(this.returning);
    }
}

