/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.entities.MerchantEntity;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageMerchantSetCreative
implements Message<MessageMerchantSetCreative> {
    private UUID worker;
    private boolean creative;

    public MessageMerchantSetCreative() {
    }

    public MessageMerchantSetCreative(UUID recruit, boolean creative) {
        this.worker = recruit;
        this.creative = creative;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        player.m_20193_().m_6443_(MerchantEntity.class, player.m_20191_().m_82400_(16.0), v -> v.m_20148_().equals(this.worker)).stream().filter(LivingEntity::m_6084_).findAny().ifPresent(merchant -> this.setCreative(player, (MerchantEntity)merchant, this.creative));
    }

    private void setCreative(ServerPlayer player, MerchantEntity merchant, boolean creative) {
        merchant.setCreative(creative);
        if (creative) {
            merchant.tellPlayer((LivingEntity)player, (Component)Component.m_237113_((String)"Im now a Creative Merchant."));
        } else {
            merchant.tellPlayer((LivingEntity)player, (Component)Component.m_237113_((String)"Im back a Survival Merchant."));
        }
    }

    @Override
    public MessageMerchantSetCreative fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        this.creative = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
        buf.writeBoolean(this.creative);
    }
}

