/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.init;

import com.talhanation.workers.client.gui.AnimalFarmerInventoryScreen;
import com.talhanation.workers.client.gui.CommandScreen;
import com.talhanation.workers.client.gui.MerchantOwnerScreen;
import com.talhanation.workers.client.gui.MerchantTradeScreen;
import com.talhanation.workers.client.gui.MerchantWaypointScreen;
import com.talhanation.workers.client.gui.MinerInventoryScreen;
import com.talhanation.workers.client.gui.WorkerHireScreen;
import com.talhanation.workers.client.gui.WorkerInventoryScreen;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.inventory.CommandMenu;
import com.talhanation.workers.inventory.MerchantInventoryContainer;
import com.talhanation.workers.inventory.MerchantTradeContainer;
import com.talhanation.workers.inventory.MerchantWaypointContainer;
import com.talhanation.workers.inventory.WorkerHireContainer;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModMenuTypes {
    private static final Logger logger = LogManager.getLogger((String)"workers");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"workers");
    public static final RegistryObject<MenuType<WorkerHireContainer>> HIRE_CONTAINER_TYPE = MENU_TYPES.register("hire_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            logger.info("{} is opening hire container for {}", (Object)inv.f_35978_.m_5446_().getString(), (Object)workerId);
            AbstractWorkerEntity rec = ModMenuTypes.getRecruitByUUID(inv.f_35978_, workerId);
            logger.info("Recruit is {}", (Object)rec);
            if (rec == null) {
                return null;
            }
            return new WorkerHireContainer(windowId, inv.f_35978_, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in hire container: ");
            logger.error(e.getMessage());
            logger.error(Arrays.toString(e.getStackTrace()));
            return null;
        }
    }));
    public static final RegistryObject<MenuType<WorkerInventoryContainer>> MINER_CONTAINER_TYPE = MENU_TYPES.register("miner_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        MinerEntity rec = (MinerEntity)ModMenuTypes.getRecruitByUUID(inv.f_35978_, data.m_130259_());
        if (rec == null) {
            return null;
        }
        return new WorkerInventoryContainer(windowId, rec, inv);
    }));
    public static final RegistryObject<MenuType<WorkerInventoryContainer>> ANIMAL_FARMER_CONTAINER_TYPE = MENU_TYPES.register("animal_farmer_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        AbstractWorkerEntity rec = ModMenuTypes.getRecruitByUUID(inv.f_35978_, data.m_130259_());
        if (rec == null) {
            return null;
        }
        return new WorkerInventoryContainer(windowId, rec, inv);
    }));
    public static final RegistryObject<MenuType<WorkerInventoryContainer>> WORKER_CONTAINER_TYPE = MENU_TYPES.register("worker_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        AbstractWorkerEntity rec = ModMenuTypes.getRecruitByUUID(inv.f_35978_, data.m_130259_());
        if (rec == null) {
            return null;
        }
        return new WorkerInventoryContainer(windowId, rec, inv);
    }));
    public static final RegistryObject<MenuType<MerchantTradeContainer>> MERCHANT_CONTAINER_TYPE = MENU_TYPES.register("merchant_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        MerchantEntity rec = (MerchantEntity)ModMenuTypes.getRecruitByUUID(inv.f_35978_, data.m_130259_());
        if (rec == null) {
            return null;
        }
        return new MerchantTradeContainer(windowId, rec, inv);
    }));
    public static final RegistryObject<MenuType<MerchantInventoryContainer>> MERCHANT_OWNER_CONTAINER_TYPE = MENU_TYPES.register("merchant_owner_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        MerchantEntity rec = (MerchantEntity)ModMenuTypes.getRecruitByUUID(inv.f_35978_, data.m_130259_());
        if (rec == null) {
            return null;
        }
        return new MerchantInventoryContainer(windowId, rec, inv);
    }));
    public static final RegistryObject<MenuType<CommandMenu>> COMMAND_CONTAINER_TYPE = MENU_TYPES.register("command_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        Player player = inv.f_35978_;
        return new CommandMenu(windowId, player);
    }));
    public static final RegistryObject<MenuType<MerchantWaypointContainer>> WAYPOINT_CONTAINER_TYPE = MENU_TYPES.register("waypoint_container", () -> IForgeMenuType.create((windowId, inv, data) -> {
        try {
            UUID workerId = data.m_130259_();
            logger.info("{} is opening waypoint container for {}", (Object)inv.f_35978_.m_5446_().getString(), (Object)workerId);
            AbstractWorkerEntity rec = ModMenuTypes.getRecruitByUUID(inv.f_35978_, workerId);
            logger.info("worker is {}", (Object)rec);
            if (rec == null) {
                return null;
            }
            return new MerchantWaypointContainer(windowId, inv.f_35978_, rec, inv);
        }
        catch (Exception e) {
            logger.error("Error in hire container: ");
            logger.error(e.getMessage());
            logger.error(Arrays.toString(e.getStackTrace()));
            return null;
        }
    }));

    public static void registerMenus() {
        ModMenuTypes.registerMenu((MenuType)MINER_CONTAINER_TYPE.get(), MinerInventoryScreen::new);
        ModMenuTypes.registerMenu((MenuType)WORKER_CONTAINER_TYPE.get(), WorkerInventoryScreen::new);
        ModMenuTypes.registerMenu((MenuType)MERCHANT_CONTAINER_TYPE.get(), MerchantTradeScreen::new);
        ModMenuTypes.registerMenu((MenuType)MERCHANT_OWNER_CONTAINER_TYPE.get(), MerchantOwnerScreen::new);
        ModMenuTypes.registerMenu((MenuType)ANIMAL_FARMER_CONTAINER_TYPE.get(), AnimalFarmerInventoryScreen::new);
        ModMenuTypes.registerMenu((MenuType)HIRE_CONTAINER_TYPE.get(), WorkerHireScreen::new);
        ModMenuTypes.registerMenu((MenuType)WAYPOINT_CONTAINER_TYPE.get(), MerchantWaypointScreen::new);
        ModMenuTypes.registerMenu((MenuType)COMMAND_CONTAINER_TYPE.get(), CommandScreen::new);
        logger.info("MenuScreens registered");
    }

    private static <M extends AbstractContainerMenu, U extends Screen> void registerMenu(MenuType<? extends M> menuType, MenuScreens.ScreenConstructor<M, U> screenConstructor) {
        MenuScreens.m_96206_(menuType, (menu, inventory, title) -> {
            try {
                return screenConstructor.m_96214_(menu, inventory, title);
            }
            catch (Exception e) {
                logger.error("Could not instantiate {}", (Object)screenConstructor.getClass().getSimpleName());
                logger.error(e.getMessage());
                logger.error(Arrays.toString(e.getStackTrace()));
                return null;
            }
        });
    }

    @Nullable
    private static AbstractWorkerEntity getRecruitByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.m_20193_().m_6443_(AbstractWorkerEntity.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_20148_().equals(uuid)).stream().findAny().orElse(null);
    }
}

