/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SleepGoal
extends Goal {
    private final AbstractWorkerEntity worker;
    private final MutableComponent NEED_BED = Component.m_237115_((String)"chat.workers.needBed");
    private final MutableComponent CANT_FIND_BED = Component.m_237115_((String)"chat.workers.cantFindBed");

    public SleepGoal(AbstractWorkerEntity worker) {
        this.worker = worker;
    }

    public boolean m_8036_() {
        return !this.worker.needsBed() && this.worker.needsToSleep() && !this.worker.getFollow();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.worker.m_5796_();
        this.worker.m_21258_();
    }

    public void m_8037_() {
        if (this.worker.m_5803_()) {
            this.worker.m_21573_().m_26573_();
            if (this.worker.needsToSleep()) {
                this.worker.m_5634_(0.025f);
            }
            return;
        }
        LivingEntity owner = this.worker.m_269323_();
        if (owner == null) {
            return;
        }
        if (owner != null && this.worker.needsBed()) {
            this.worker.tellPlayer(owner, (Component)this.NEED_BED);
            return;
        }
        BlockPos sleepPos = this.worker.getBedPos();
        if (sleepPos == null) {
            this.worker.tellPlayer(owner, (Component)this.NEED_BED);
            this.worker.setNeedsBed(true);
            return;
        }
        BlockEntity bedEntity = this.worker.m_20193_().m_7702_(sleepPos);
        if (bedEntity == null || !bedEntity.m_58900_().isBed((BlockGetter)this.worker.m_20193_(), sleepPos, (LivingEntity)this.worker)) {
            this.worker.tellPlayer(owner, (Component)this.CANT_FIND_BED);
            this.worker.setNeedsBed(true);
            return;
        }
        if (!((Boolean)bedEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61445_)).booleanValue()) {
            this.goToBed(sleepPos);
        }
    }

    private void goToBed(BlockPos bedPos) {
        if (bedPos == null) {
            return;
        }
        PathNavigation pathFinder = this.worker.m_21573_();
        pathFinder.m_26519_((double)bedPos.m_123341_(), (double)bedPos.m_123342_(), (double)bedPos.m_123343_(), 1.1);
        this.worker.m_21563_().m_24950_((double)bedPos.m_123341_(), (double)(bedPos.m_123342_() + 1), (double)bedPos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
        if (bedPos.m_123333_((Vec3i)this.worker.getWorkerOnPos()) <= 5) {
            this.worker.m_5802_(bedPos);
            this.worker.m_21250_(bedPos);
            pathFinder.m_26573_();
        }
    }
}

