/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.base.Predicates;
import com.talhanation.workers.entities.ShepherdEntity;
import com.talhanation.workers.entities.ai.AnimalFarmerAI;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Items;

public class ShepherdAI
extends AnimalFarmerAI {
    private Optional<Sheep> sheep;
    private boolean sheering;
    private boolean breeding;
    private boolean slaughtering;
    private BlockPos workPos;

    public ShepherdAI(ShepherdEntity worker) {
        this.animalFarmer = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.animalFarmer.canWork();
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.animalFarmer.getStartPos();
        this.sheering = true;
        this.breeding = false;
        this.slaughtering = false;
    }

    @Override
    public void performWork() {
        if (this.workPos != null && !this.workPos.m_123314_((Vec3i)this.animalFarmer.m_20097_(), 10.0) && !this.animalFarmer.getFollow()) {
            this.animalFarmer.m_21573_().m_26519_((double)this.workPos.m_123341_(), (double)this.workPos.m_123342_(), (double)this.workPos.m_123343_(), 1.0);
        }
        if (this.sheering) {
            this.sheep = this.findSheepSheering();
            if (this.hasMainToolInInv() && this.sheep.isPresent() && this.sheep.get().m_6220_()) {
                this.animalFarmer.m_21573_().m_5624_((Entity)this.sheep.get(), 1.0);
                if (!this.animalFarmer.isRequiredMainTool(this.animalFarmer.m_21205_())) {
                    this.animalFarmer.changeToTool(true);
                }
                if (this.sheep.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                    this.sheerSheep(this.sheep.get());
                    this.animalFarmer.m_21563_().m_24950_(this.sheep.get().m_20185_(), this.sheep.get().m_20188_(), this.sheep.get().m_20189_(), 10.0f, (float)this.animalFarmer.m_8132_());
                    this.sheep = Optional.empty();
                }
            } else {
                this.sheering = false;
                this.breeding = true;
            }
        }
        if (this.breeding) {
            this.sheep = this.findSheepBreeding();
            if (this.sheep.isPresent()) {
                int i = this.sheep.get().m_146764_();
                if (i == 0 && this.hasBreedItem(Items.f_42405_)) {
                    this.animalFarmer.changeToBreedItem(Items.f_42405_);
                    this.animalFarmer.m_21573_().m_5624_((Entity)this.sheep.get(), 1.0);
                    if (this.sheep.get().m_19950_((Entity)this.animalFarmer, 2.0)) {
                        this.animalFarmer.workerSwingArm();
                        this.consumeBreedItem(Items.f_42405_);
                        this.animalFarmer.m_21563_().m_24950_(this.sheep.get().m_20185_(), this.sheep.get().m_20188_(), this.sheep.get().m_20189_(), 10.0f, (float)this.animalFarmer.m_8132_());
                        this.sheep.get().m_27595_(null);
                        this.sheep = Optional.empty();
                    }
                } else {
                    this.breeding = false;
                    this.slaughtering = true;
                }
            } else {
                this.breeding = false;
                this.slaughtering = true;
            }
        }
        if (this.slaughtering) {
            List<Sheep> sheeps = this.findSheepSlaughtering();
            if (sheeps.size() > this.animalFarmer.getMaxAnimalCount()) {
                this.sheep = sheeps.stream().findFirst();
                if (this.sheep.isPresent() && this.hasSecondToolInInv()) {
                    this.animalFarmer.m_21573_().m_26519_(this.sheep.get().m_20185_(), this.sheep.get().m_20186_(), this.sheep.get().m_20189_(), 1.0);
                    if (!this.animalFarmer.isRequiredSecondTool(this.animalFarmer.m_21205_())) {
                        this.animalFarmer.changeToTool(false);
                    }
                    if (this.sheep.get().m_20097_().m_123314_((Vec3i)this.animalFarmer.m_20097_(), 2.0)) {
                        this.animalFarmer.workerSwingArm();
                        this.sheep.get().m_6074_();
                        this.animalFarmer.m_216990_(SoundEvents.f_12316_);
                        this.animalFarmer.consumeToolDurability();
                        this.animalFarmer.increaseFarmedItems();
                    }
                } else {
                    this.slaughtering = false;
                    this.sheering = true;
                }
            } else {
                this.slaughtering = false;
                this.sheering = true;
            }
        }
    }

    public void sheerSheep(Sheep sheepEntity) {
        sheepEntity.m_5851_(SoundSource.PLAYERS);
        sheepEntity.m_29878_(true);
        this.animalFarmer.increaseFarmedItems();
        if (!this.animalFarmer.f_20911_) {
            this.animalFarmer.workerSwingArm();
        }
        this.animalFarmer.consumeToolDurability();
    }

    private Optional<Sheep> findSheepSheering() {
        return this.animalFarmer.m_20193_().m_6443_(Sheep.class, this.animalFarmer.m_20191_().m_82400_(8.0), Sheep::m_6220_).stream().filter(Predicates.not(AgeableMob::m_6162_)).findAny();
    }

    private Optional<Sheep> findSheepBreeding() {
        return this.animalFarmer.m_20193_().m_6443_(Sheep.class, this.animalFarmer.m_20191_().m_82400_(8.0), Animal::m_5957_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).findAny();
    }

    private List<Sheep> findSheepSlaughtering() {
        return this.animalFarmer.m_20193_().m_6443_(Sheep.class, this.animalFarmer.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).collect(Collectors.toList());
    }
}

