/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.MerchantEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.vehicle.Boat;

public class MerchantAI
extends Goal {
    private final MerchantEntity merchant;
    private MerchantEntity.State state;
    private boolean arrivedMessage;
    private boolean homeMessage;
    private boolean returningMessage;
    private float precision;
    private int timer;
    private Boat boat;
    private List<Entity> prevPassengers;

    public MerchantAI(MerchantEntity merchant) {
        this.merchant = merchant;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.merchant.getIsWorking() && !this.merchant.getFollow();
    }

    public void m_8056_() {
        this.setWorkState(MerchantEntity.State.IDLE);
    }

    public void m_8037_() {
        int indexChange;
        if (this.state == null) {
            this.state = MerchantEntity.State.fromIndex(this.merchant.getState());
        }
        int n = indexChange = this.merchant.getReturning() ? -1 : 1;
        boolean condition = this.merchant.getReturning() ? this.merchant.getCurrentWayPointIndex() == 0 : this.merchant.getCurrentWayPointIndex() == this.merchant.WAYPOINTS.size() - 1;
        MerchantEntity.State nextState = this.merchant.getReturning() ? MerchantEntity.State.HOME : MerchantEntity.State.ARRIVED;
        switch (this.state) {
            case IDLE: {
                if (!this.merchant.getTraveling()) break;
                this.returningMessage = false;
                this.homeMessage = false;
                this.arrivedMessage = false;
                this.precision = 10.0f;
                int index = this.merchant.getCurrentWayPointIndex();
                if (index >= 0 && index < this.merchant.WAYPOINTS.size()) {
                    this.merchant.setCurrentWayPoint(this.merchant.WAYPOINTS.get(index));
                }
                this.changeTravelType();
                break;
            }
            case MOVE_TO_BOAT: {
                this.searchForBoat();
                if (this.boat != null) {
                    this.moveToPos(this.boat.m_20097_(), 1.0f);
                    if (this.boat.m_20097_().m_123314_((Vec3i)this.merchant.m_20097_(), 4.0)) {
                        this.boardBoat(this.boat);
                    }
                    if (this.boat.m_146895_() == null || !this.merchant.equals(this.boat.m_146895_())) break;
                    if (this.prevPassengers != null && !this.prevPassengers.isEmpty()) {
                        for (Entity passenger : this.prevPassengers) {
                            passenger.m_7998_((Entity)this.boat, true);
                        }
                        this.prevPassengers = null;
                    }
                    this.setWorkState(MerchantEntity.State.SAILING);
                    break;
                }
                this.setWorkState(MerchantEntity.State.TRAVELING_GROUND);
                break;
            }
            case SAILING: {
                this.moveToWayPoint(indexChange, nextState, this.merchant.getCurrentWayPointIndex() == this.merchant.WAYPOINTS.size() - 1, true);
                break;
            }
            case TRAVELING_GROUND: {
                if (this.merchant.m_20202_() instanceof Boat) {
                    this.merchant.m_8127_();
                }
                this.moveToWayPoint(indexChange, nextState, condition, false);
                break;
            }
            case ARRIVED: {
                if (!this.arrivedMessage && this.merchant.m_269323_() != null && this.merchant.getSendInfo()) {
                    this.merchant.tellPlayer(this.merchant.m_269323_(), (Component)Component.m_237113_((String)"I've arrived at my last waypoint."));
                    this.arrivedMessage = true;
                }
                if (!this.merchant.isReturnTimeElapsed() && !this.merchant.getReturning()) break;
                this.merchant.setReturning(true);
                this.merchant.setCurrentReturningTime(0);
                if (!this.returningMessage && this.merchant.m_269323_() != null && this.merchant.getSendInfo()) {
                    this.merchant.tellPlayer(this.merchant.m_269323_(), (Component)Component.m_237113_((String)"I'm returning now."));
                    this.returningMessage = true;
                }
                this.setWorkState(MerchantEntity.State.IDLE);
                break;
            }
            case HOME: {
                if (!this.homeMessage && this.merchant.m_269323_() != null && this.merchant.getSendInfo()) {
                    this.merchant.tellPlayer(this.merchant.m_269323_(), (Component)Component.m_237113_((String)"I've arrived where i've started."));
                    this.homeMessage = true;
                }
                this.merchant.setTraveling(false);
                this.merchant.setReturning(false);
                if (this.merchant.getAutoStartTravel()) {
                    if (!this.merchant.isReturnTimeElapsed()) break;
                    this.merchant.setCurrentReturningTime(0);
                    this.merchant.setTraveling(true);
                    this.setWorkState(MerchantEntity.State.IDLE);
                    break;
                }
                this.setWorkState(MerchantEntity.State.IDLE);
            }
        }
    }

    private void setWorkState(MerchantEntity.State state) {
        this.state = state;
        this.merchant.setState(state.getIndex());
    }

    private void moveToWayPoint(int indexChange, MerchantEntity.State nextState, boolean condition, boolean isSailing) {
        int index = this.merchant.getCurrentWayPointIndex();
        if (index >= this.merchant.WAYPOINTS.size()) {
            index = this.merchant.WAYPOINTS.size() - 1;
        }
        if (index < this.merchant.WAYPOINTS.size() && index >= 0) {
            this.merchant.setCurrentWayPoint(this.merchant.WAYPOINTS.get(index));
            BlockPos pos = this.merchant.getCurrentWayPoint();
            if (isSailing) {
                this.merchant.setSailPos(pos);
            } else {
                float speed = 0.0f;
                switch (this.merchant.getTravelSpeedState()) {
                    default: {
                        speed = 0.8f;
                        break;
                    }
                    case 0: {
                        speed = 0.5f;
                        break;
                    }
                    case 2: {
                        speed = 1.1f;
                    }
                }
                this.moveToPos(pos, speed);
            }
            double distance = this.merchant.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            if (distance <= (double)this.precision) {
                if (condition) {
                    this.setWorkState(nextState);
                } else if (index <= this.merchant.WAYPOINTS.size() - 1) {
                    this.merchant.setCurrentWayPointIndex(index + indexChange);
                    this.precision = !this.merchant.isFreeWater(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) ? 10.0f : 75.0f;
                }
            } else if (++this.timer > 100 && isSailing) {
                if (this.precision < 250.0f) {
                    this.precision += 25.0f;
                }
                this.timer = 0;
            }
        }
        this.changeTravelType();
    }

    private void searchForBoat() {
        List list = this.merchant.m_20193_().m_45976_(Boat.class, this.merchant.m_20191_().m_82400_(16.0));
        list.sort(Comparator.comparing(boatInList -> Float.valueOf(boatInList.m_20270_((Entity)this.merchant))));
        boolean getClosest = false;
        if (this.merchant.getBoatUUID() != null) {
            if (list.isEmpty()) {
                getClosest = true;
            } else {
                for (Boat boat : list) {
                    if (this.merchant.getBoatUUID() == null || !boat.m_20148_().equals(this.merchant.getBoatUUID())) continue;
                    this.boat = boat;
                }
                if (this.boat == null) {
                    getClosest = true;
                }
            }
        } else {
            getClosest = true;
        }
        if (!list.isEmpty() && getClosest) {
            this.merchant.setBoatUUID(Optional.of(((Boat)list.get(0)).m_20148_()));
            this.boat = (Boat)list.get(0);
        }
    }

    private void boardBoat(Boat boat) {
        this.prevPassengers = new ArrayList<Entity>();
        if (!boat.m_20197_().isEmpty()) {
            this.prevPassengers = boat.m_20197_();
            for (Entity passenger : this.prevPassengers) {
                passenger.m_8127_();
            }
        }
        this.merchant.m_20329_((Entity)boat);
        this.boat = boat;
    }

    private void moveToPos(BlockPos pos, float speed) {
        BlockPos workerPos = this.merchant.m_20097_();
        int heightDiff = Math.abs(workerPos.m_123342_() - pos.m_123342_());
        double distance = this.merchant.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.merchant.walkTowards(pos, speed);
        if (heightDiff >= 4) {
            // empty if block
        }
    }

    private void changeTravelType() {
        if (this.merchant.getCurrentWayPoint() != null && this.merchant.isWaterBlockPos(this.merchant.getCurrentWayPoint())) {
            if (this.boat != null && this.boat.m_146895_() != null && this.merchant.equals(this.boat.m_146895_())) {
                this.setWorkState(MerchantEntity.State.SAILING);
            } else {
                this.setWorkState(MerchantEntity.State.MOVE_TO_BOAT);
            }
        } else if (this.state != MerchantEntity.State.ARRIVED && this.state != MerchantEntity.State.HOME) {
            this.setWorkState(MerchantEntity.State.TRAVELING_GROUND);
        }
    }
}

