/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.LumberjackEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class LumberjackAI
extends Goal {
    private final LumberjackEntity lumber;
    private BlockPos workPos;
    private LumberjackEntity.State state;

    public LumberjackAI(LumberjackEntity lumber) {
        this.lumber = lumber;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.lumber.m_21824_() && this.lumber.getStartPos() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.lumber.getStartPos();
        this.lumber.resetWorkerParameters();
        this.state = LumberjackEntity.State.fromIndex(this.lumber.getState());
    }

    public void m_8037_() {
        this.breakLeaves();
        switch (this.state) {
            case IDLE: {
                if (this.lumber.getStartPos() == null || !this.lumber.canWork()) break;
                this.setWorkState(LumberjackEntity.State.CALC_WORK_POS);
                break;
            }
            case CALC_WORK_POS: {
                if (!this.lumber.canWork()) {
                    this.setWorkState(LumberjackEntity.State.STOP);
                }
                if (this.lumber.m_20202_() != null) {
                    this.lumber.m_8127_();
                }
                this.workPos = this.lumber.getStartPos();
                if (this.workPos != null) {
                    this.setWorkState(LumberjackEntity.State.WORKING);
                    break;
                }
                this.setWorkState(LumberjackEntity.State.STOP);
                break;
            }
            case WORKING: {
                boolean standingBelowChopPos;
                if (!this.lumber.canWork()) {
                    this.setWorkState(LumberjackEntity.State.STOP);
                }
                if (this.lumber.m_20202_() != null) {
                    this.lumber.m_8127_();
                }
                if (this.isInSapling()) {
                    this.lumber.walkTowards(this.lumber.getStartPos(), 1.0);
                }
                if (this.workPos != null) {
                    if (!this.workPos.m_123314_((Vec3i)this.lumber.m_20097_(), 12.0)) {
                        this.lumber.walkTowards(this.workPos, 1.0);
                    }
                    if (!this.workPos.m_123314_((Vec3i)this.lumber.m_20097_(), 3.5)) {
                        this.lumber.m_21566_().m_6849_((double)this.workPos.m_123341_(), (double)this.lumber.getStartPos().m_123342_(), (double)this.workPos.m_123343_(), 1.0);
                    } else {
                        this.lumber.m_21573_().m_26573_();
                    }
                } else {
                    this.setWorkState(LumberjackEntity.State.CALC_WORK_POS);
                }
                BlockPos chopPos = this.getWoodPos();
                if (chopPos == null) {
                    return;
                }
                BlockPos lumberPos = this.lumber.m_20183_();
                this.lumber.m_21566_().m_6849_((double)chopPos.m_123341_(), (double)chopPos.m_123342_(), (double)chopPos.m_123343_(), 1.0);
                boolean bl = standingBelowChopPos = lumberPos.m_123341_() == chopPos.m_123341_() && lumberPos.m_123343_() == chopPos.m_123343_() && lumberPos.m_123342_() < chopPos.m_123342_();
                if (!chopPos.m_123314_((Vec3i)this.lumber.m_20183_(), 9.0) && !standingBelowChopPos) break;
                if (this.mineBlock(chopPos)) {
                    this.lumber.increaseFarmedItems();
                }
                if (!this.lumber.getReplantSaplings() || !this.lumber.m_20193_().m_8055_(chopPos.m_7495_()).m_60713_(Blocks.f_50493_) || !this.lumber.m_20193_().m_46859_(chopPos)) break;
                this.plantSaplingFromInv(chopPos);
                break;
            }
            case STOP: {
                this.lumber.m_8127_();
                if (this.lumber.needsToSleep()) {
                    this.setWorkState(LumberjackEntity.State.SLEEP);
                    break;
                }
                if (this.lumber.needsToDeposit()) {
                    this.setWorkState(LumberjackEntity.State.DEPOSIT);
                    break;
                }
                if (this.lumber.needsToGetFood()) {
                    this.setWorkState(LumberjackEntity.State.UPKEEP);
                    break;
                }
                this.lumber.walkTowards(this.workPos, 1.0);
                double distance = this.lumber.m_20275_(this.lumber.m_20185_(), this.lumber.m_20186_(), this.lumber.m_20189_());
                if (!(distance < 5.5)) break;
                this.m_8041_();
                break;
            }
            case DEPOSIT: {
                this.lumber.m_8127_();
                if (this.lumber.needsToDeposit()) break;
                this.setWorkState(LumberjackEntity.State.IDLE);
                break;
            }
            case UPKEEP: {
                this.lumber.m_8127_();
                if (this.lumber.needsToGetFood()) break;
                this.setWorkState(LumberjackEntity.State.IDLE);
                break;
            }
            case SLEEP: {
                this.lumber.m_8127_();
                if (this.lumber.needsToSleep()) break;
                this.setWorkState(LumberjackEntity.State.IDLE);
            }
        }
    }

    public boolean isInSapling() {
        for (int i = -1; i <= 1; ++i) {
            BlockPos blockPos = this.lumber.m_20097_();
            if (!this.lumber.m_20193_().m_8055_(blockPos.m_7494_()).m_204336_(BlockTags.f_13104_)) continue;
            return true;
        }
        return false;
    }

    public void m_8041_() {
        this.setWorkState(LumberjackEntity.State.IDLE);
        super.m_8041_();
    }

    private void setWorkState(@NotNull LumberjackEntity.State state) {
        this.state = state;
        this.lumber.setState(state.getIndex());
    }

    private void breakLeaves() {
        AABB boundingBox = this.lumber.m_20191_();
        double offset = 0.25;
        BlockPos start = new BlockPos((int)(boundingBox.f_82288_ - offset), (int)(boundingBox.f_82289_ - offset), (int)(boundingBox.f_82290_ - offset));
        BlockPos end = new BlockPos((int)(boundingBox.f_82291_ + offset), (int)(boundingBox.f_82292_ + offset), (int)(boundingBox.f_82293_ + offset));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean hasBroken = false;
        if (this.lumber.m_20193_().m_46832_(start, end)) {
            for (int i = start.m_123341_(); i <= end.m_123341_(); ++i) {
                for (int j = start.m_123342_(); j <= end.m_123342_(); ++j) {
                    for (int k = start.m_123343_(); k <= end.m_123343_(); ++k) {
                        pos.m_122178_(i, j, k);
                        BlockState blockstate = this.lumber.m_20193_().m_8055_((BlockPos)pos);
                        if (!blockstate.m_204336_(BlockTags.f_13035_)) continue;
                        this.lumber.m_20193_().m_46953_((BlockPos)pos, true, (Entity)this.lumber);
                        hasBroken = true;
                    }
                }
            }
        }
        if (hasBroken) {
            this.lumber.m_20193_().m_6263_(null, this.lumber.m_20185_(), this.lumber.m_20186_(), this.lumber.m_20189_(), SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.1f);
            this.lumber.workerSwingArm();
        }
    }

    public BlockPos getWoodPos() {
        int range = 16;
        for (int j = 0; j < range; ++j) {
            for (int i = 0; i < range; ++i) {
                for (int k = 0; k < range * 2; ++k) {
                    BlockPos blockPos = this.workPos.m_7918_((int)((float)j - (float)range / 2.0f), k, (int)((float)i - (float)range / 2.0f));
                    BlockState blockState = this.lumber.m_20193_().m_8055_(blockPos);
                    if (!this.lumber.wantsToBreak(blockState.m_60734_())) continue;
                    return blockPos;
                }
            }
        }
        return null;
    }

    private void plantSaplingFromInv(BlockPos blockPos) {
        SimpleContainer inventory = this.lumber.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (itemstack.m_41619_() || !itemstack.m_204117_(ItemTags.f_13180_)) continue;
            BlockState placedSaplingBlock = Block.m_49814_((Item)itemstack.m_41720_()).m_49966_();
            this.lumber.m_20193_().m_7731_(blockPos, placedSaplingBlock, 3);
            this.lumber.m_20193_().m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            if (!itemstack.m_41619_()) break;
            inventory.m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }

    private boolean mineBlock(BlockPos blockPos) {
        if (this.lumber.m_6084_() && ForgeEventFactory.getMobGriefingEvent((Level)this.lumber.m_20193_(), (Entity)this.lumber) && !this.lumber.getFollow()) {
            BlockState blockstate = this.lumber.m_20193_().m_8055_(blockPos);
            Block block = blockstate.m_60734_();
            ItemStack heldItem = this.lumber.m_21120_(InteractionHand.MAIN_HAND);
            if (this.lumber.wantsToBreak(block)) {
                if (this.lumber.getCurrentTimeBreak() % 5 == 4) {
                    this.lumber.m_20193_().m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), blockstate.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
                }
                int bp = (int)(blockstate.m_60800_((BlockGetter)this.lumber.m_20193_(), blockPos) * 30.0f);
                this.lumber.setBreakingTime(bp);
                this.lumber.setCurrentTimeBreak(this.lumber.getCurrentTimeBreak() + (int)(1.0f * heldItem.m_41691_(blockstate)));
                float f = (float)this.lumber.getCurrentTimeBreak() / (float)this.lumber.getBreakingTime();
                int i = (int)(f * 10.0f);
                if (i != this.lumber.getPreviousTimeBreak()) {
                    this.lumber.m_20193_().m_6801_(1, blockPos, i);
                    this.lumber.setPreviousTimeBreak(i);
                }
                if (this.lumber.getCurrentTimeBreak() >= this.lumber.getBreakingTime()) {
                    this.lumber.m_20193_().m_46953_(blockPos, true, (Entity)this.lumber);
                    this.lumber.setCurrentTimeBreak(-1);
                    this.lumber.setBreakingTime(0);
                    this.lumber.consumeToolDurability();
                    return true;
                }
                this.lumber.workerSwingArm();
            }
        }
        return false;
    }
}

