/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.base.Predicates;
import com.talhanation.workers.entities.ShepherdEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GoatFarmerAI
extends Goal {
    private Optional<Goat> goat;
    private final ShepherdEntity shepherd;
    private boolean milking;
    private boolean breeding;
    private boolean slaughtering;
    private BlockPos workPos;

    public GoatFarmerAI(ShepherdEntity worker, int coolDown) {
        this.shepherd = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.shepherd.m_20193_().m_46461_()) {
            return false;
        }
        return this.shepherd.getIsWorking() && !this.shepherd.getFollow();
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.shepherd.getStartPos();
        this.milking = true;
        this.breeding = false;
        this.slaughtering = false;
    }

    public void m_8037_() {
        super.m_8037_();
        if (!this.workPos.m_123314_((Vec3i)this.shepherd.m_20097_(), 10.0) && this.workPos != null && !this.shepherd.getFollow()) {
            this.shepherd.m_21573_().m_26519_((double)this.workPos.m_123341_(), (double)this.workPos.m_123342_(), (double)this.workPos.m_123343_(), 1.0);
        }
        if (this.milking) {
            this.goat = this.findGoatMilking();
            if (this.goat.isPresent() && this.hasBucket()) {
                this.shepherd.m_21573_().m_5624_((Entity)this.goat.get(), 1.0);
                this.shepherd.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42446_));
                if (this.goat.get().m_19950_((Entity)this.shepherd, 1.5)) {
                    this.milkCow(this.goat.get());
                    this.shepherd.m_21563_().m_24950_(this.goat.get().m_20185_(), this.goat.get().m_20188_(), this.goat.get().m_20189_(), 10.0f, (float)this.shepherd.m_8132_());
                    this.goat = Optional.empty();
                }
            } else {
                this.milking = false;
                this.breeding = true;
                this.shepherd.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        if (this.breeding) {
            this.goat = this.findGoatMilking();
            if (this.goat.isPresent()) {
                int i = this.goat.get().m_146764_();
                if (i == 0 && this.hasWheat()) {
                    this.shepherd.m_21573_().m_5624_((Entity)this.goat.get(), 1.0);
                    this.shepherd.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42405_));
                    if (this.goat.get().m_19950_((Entity)this.shepherd, 1.5)) {
                        this.consumeWheat();
                        this.shepherd.m_21563_().m_24950_(this.goat.get().m_20185_(), this.goat.get().m_20188_(), this.goat.get().m_20189_(), 10.0f, (float)this.shepherd.m_8132_());
                        this.goat.get().m_27595_(null);
                        this.goat = Optional.empty();
                    }
                } else {
                    this.shepherd.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    this.breeding = false;
                    this.slaughtering = true;
                }
            } else {
                this.shepherd.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.breeding = false;
                this.slaughtering = true;
            }
        }
        if (this.slaughtering) {
            List<Goat> cows = this.findGoatSlaughtering();
            if (cows.size() > this.shepherd.getMaxAnimalCount()) {
                this.goat = cows.stream().findFirst();
                if (this.goat.isPresent()) {
                    this.shepherd.m_21573_().m_26519_(this.goat.get().m_20185_(), this.goat.get().m_20186_(), this.goat.get().m_20189_(), 1.0);
                    if (this.goat.get().m_19950_((Entity)this.shepherd, 1.5)) {
                        ItemStack stack = Items.f_42658_.m_7968_();
                        stack.m_41764_(this.shepherd.m_217043_().m_188503_(2));
                        this.goat.get().m_19983_(stack);
                        this.goat.get().m_6074_();
                        this.shepherd.workerSwingArm();
                    }
                }
            } else {
                this.slaughtering = false;
                this.milking = true;
            }
        }
    }

    private void consumeWheat() {
        SimpleContainer inventory = this.shepherd.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42405_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    public void milkCow(Goat cow) {
        this.shepherd.workerSwingArm();
        SimpleContainer inventory = this.shepherd.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42446_)) continue;
            itemStack.m_41774_(1);
        }
        inventory.m_19173_(Items.f_42455_.m_7968_());
        cow.m_5496_(cow.m_149397_() ? SoundEvents.f_144148_ : SoundEvents.f_144168_, 1.0f, 1.0f);
    }

    public boolean hasBucket() {
        SimpleContainer inventory = this.shepherd.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42446_)) continue;
            return true;
        }
        return false;
    }

    private Optional<Goat> findGoatMilking() {
        return this.shepherd.m_20193_().m_6443_(Goat.class, this.shepherd.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).findAny();
    }

    private List<Goat> findGoatSlaughtering() {
        return this.shepherd.m_20193_().m_6443_(Goat.class, this.shepherd.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).collect(Collectors.toList());
    }

    private boolean hasWheat() {
        SimpleContainer inventory = this.shepherd.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_41720_().equals(Items.f_42405_) || itemStack.m_41613_() < 2) continue;
            return true;
        }
        return false;
    }
}

