/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.ChickenFarmerEntity;
import com.talhanation.workers.entities.MinerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class DepositItemsInChestGoal
extends Goal {
    private final AbstractWorkerEntity worker;
    public BlockPos chestPos;
    public Container container;
    public boolean message;
    public int timer = 0;
    public boolean setTimer = false;

    public DepositItemsInChestGoal(AbstractWorkerEntity worker) {
        this.worker = worker;
    }

    public boolean m_8036_() {
        return this.worker.needsToDeposit();
    }

    public void m_8056_() {
        super.m_8056_();
        this.message = false;
        this.chestPos = this.worker.getChestPos();
        if (this.chestPos != null) {
            BlockEntity entity = this.worker.m_20193_().m_7702_(this.chestPos);
            BlockState blockState = this.worker.m_20193_().m_8055_(this.chestPos);
            Block block = blockState.m_60734_();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                this.container = ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)blockState, (Level)this.worker.m_20193_(), (BlockPos)this.chestPos, (boolean)false);
            } else if (entity instanceof Container) {
                Container containerEntity;
                this.container = containerEntity = (Container)entity;
            } else {
                this.message = true;
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.container != null) {
            this.interactChest(this.container, false);
        }
        this.timer = 0;
        this.setTimer = false;
        this.worker.resetFarmedItems();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        this.chestPos = this.worker.getChestPos();
        if (this.chestPos != null) {
            BlockEntity entity = this.worker.m_20193_().m_7702_(this.chestPos);
            if (entity instanceof Container) {
                Container containerEntity;
                this.container = containerEntity = (Container)entity;
            } else {
                this.message = true;
            }
            this.worker.m_21573_().m_26519_((double)this.chestPos.m_123341_(), (double)this.chestPos.m_123342_(), (double)this.chestPos.m_123343_(), 1.1);
            if (this.chestPos.m_123314_((Vec3i)this.worker.m_20097_(), 2.5) && this.container != null) {
                this.worker.m_21573_().m_26573_();
                this.worker.m_21563_().m_24950_((double)this.chestPos.m_123341_(), (double)(this.chestPos.m_123342_() + 1), (double)this.chestPos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
                if (!this.setTimer) {
                    ChickenFarmerEntity chickenFarmer;
                    AbstractWorkerEntity abstractWorkerEntity;
                    this.interactChest(this.container, true);
                    this.depositItems(this.container);
                    this.reequipTool();
                    if (this.worker instanceof MinerEntity) {
                        this.reequipTorch();
                    }
                    if ((abstractWorkerEntity = this.worker) instanceof ChickenFarmerEntity && (chickenFarmer = (ChickenFarmerEntity)abstractWorkerEntity).getUseEggs()) {
                        this.getEggsFromChest();
                    }
                    this.timer = 50;
                    this.setTimer = true;
                }
            }
        } else {
            this.message = true;
        }
        if (this.message && this.worker.m_269323_() != null) {
            this.worker.tellPlayer(this.worker.m_269323_(), (Component)Translatable.TEXT_CANT_FIND_CHEST);
            this.worker.setNeedsChest(true);
        }
        if (this.setTimer) {
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer == 0) {
                this.m_8041_();
            }
        }
    }

    public void interactChest(Container container, boolean open) {
        if (container instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)container;
            if (open) {
                this.worker.m_20193_().m_7696_(this.chestPos, chest.m_58900_().m_60734_(), 1, 1);
                this.worker.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11749_, this.worker.m_5720_(), 0.7f, 0.8f + 0.4f * this.worker.m_217043_().m_188501_());
            } else {
                this.worker.m_20193_().m_7696_(this.chestPos, chest.m_58900_().m_60734_(), 1, 0);
                this.worker.m_20193_().m_5594_(null, this.chestPos, SoundEvents.f_11747_, this.worker.m_5720_(), 0.7f, 0.8f + 0.4f * this.worker.m_217043_().m_188501_());
            }
            this.worker.m_20193_().m_142346_((Entity)this.worker, open ? GameEvent.f_157796_ : GameEvent.f_157793_, this.chestPos);
        }
    }

    private void reequipTool() {
        if (this.worker.needsTool()) {
            boolean hasMainHand = this.worker.getInventory().m_216874_(this.worker::isRequiredMainTool);
            boolean hasOffHand = this.worker.getInventory().m_216874_(this.worker::isRequiredSecondTool);
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                ItemStack stack = this.container.m_8020_(i);
                if (!hasMainHand && this.worker.isRequiredMainTool(stack)) {
                    this.take(stack);
                }
                if (hasOffHand || !this.worker.isRequiredSecondTool(stack)) continue;
                this.take(stack);
            }
            this.worker.setNeedsTool(false);
        }
    }

    private void reequipTorch() {
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_150930_(Items.f_42000_)) continue;
            this.worker.getInventory().m_19173_(stack.m_41777_());
            this.container.m_8016_(i);
            break;
        }
    }

    private void getEggsFromChest() {
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_150930_(Items.f_42521_)) continue;
            this.worker.getInventory().m_19173_(stack.m_41777_());
            this.container.m_8016_(i);
            break;
        }
    }

    private void take(ItemStack stack) {
        ItemStack tool = stack.m_41777_();
        this.worker.getInventory().m_19173_(tool);
        stack.m_41774_(1);
    }

    private void depositItems(Container container) {
        SimpleContainer inventory = this.worker.getInventory();
        if (this.isContainerFull(container)) {
            this.worker.setNeedsChest(true);
            if (this.worker.m_269323_() != null) {
                this.worker.tellPlayer(this.worker.m_269323_(), (Component)Translatable.TEXT_CHEST_FULL);
            }
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_150930_(Items.f_41852_) || stack.m_41619_() || !this.worker.m_7243_(stack) || this.worker.wantsToKeep(stack)) continue;
            ItemStack remainder = this.deposit(stack, container);
            inventory.m_6836_(i, remainder);
        }
    }

    private boolean isContainerFull(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (!itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private ItemStack deposit(ItemStack stack, Container container) {
        ItemStack targetStack;
        int i;
        for (i = 0; i < container.m_6643_(); ++i) {
            targetStack = container.m_8020_(i);
            if (!targetStack.m_150930_(stack.m_41720_())) continue;
            int amountToDeposit = Math.min(stack.m_41613_(), targetStack.m_41741_() - targetStack.m_41613_());
            targetStack.m_41769_(amountToDeposit);
            stack.m_41774_(amountToDeposit);
            container.m_6836_(i, targetStack);
            if (!stack.m_41619_()) continue;
            return stack;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            targetStack = container.m_8020_(i);
            if (!targetStack.m_41619_()) continue;
            container.m_6836_(i, stack);
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

