/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.google.common.base.Predicates;
import com.talhanation.workers.entities.BeekeeperEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BeekeeperAI
extends Goal {
    private final BeekeeperEntity beekeeper;
    private boolean breeding;
    private BlockPos workPos;

    public BeekeeperAI(BeekeeperEntity worker) {
        this.beekeeper = worker;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.beekeeper.canWork();
    }

    public void m_8056_() {
        super.m_8056_();
        this.workPos = this.beekeeper.getStartPos();
        this.breeding = true;
    }

    private void consumeFlowers() {
        SimpleContainer inventory = this.beekeeper.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_204117_(ItemTags.f_13149_)) continue;
            itemStack.m_41774_(1);
            break;
        }
    }

    private Optional<Bee> findBeeBreeding() {
        return this.beekeeper.m_20193_().m_6443_(Bee.class, this.beekeeper.m_20191_().m_82400_(8.0), LivingEntity::m_6084_).stream().filter(Predicates.not(AgeableMob::m_6162_)).filter(Predicates.not(Animal::m_27593_)).findAny();
    }

    private boolean hasFlowers() {
        SimpleContainer inventory = this.beekeeper.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_204117_(ItemTags.f_13149_) || itemStack.m_41613_() < 2) continue;
            return true;
        }
        return false;
    }

    public BlockPos getPlantPos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                for (int k = -3; k <= 3; ++k) {
                    BlockPos blockPos = this.beekeeper.getStartPos().m_7918_(j - 4, k, i - 4);
                    BlockPos aboveBlockPos = blockPos.m_7494_();
                    BlockState blockState = this.beekeeper.m_20193_().m_8055_(blockPos);
                    BlockState aboveBlockState = this.beekeeper.m_20193_().m_8055_(aboveBlockPos);
                    Block block = blockState.m_60734_();
                    Block aboveBlock = aboveBlockState.m_60734_();
                    if (block != Blocks.f_50440_ || aboveBlock != Blocks.f_50016_) continue;
                    return aboveBlockPos;
                }
            }
        }
        return null;
    }

    public BlockPos getBeePos() {
        for (int j = 0; j <= 8; ++j) {
            for (int i = 0; i <= 8; ++i) {
                for (int k = -3; k <= 3; ++k) {
                    BlockPos blockPos = this.beekeeper.getStartPos().m_7918_(j - 4, k, i - 4);
                    BlockState blockState = this.beekeeper.m_20193_().m_8055_(blockPos);
                    Block block = blockState.m_60734_();
                    if (block != Blocks.f_50717_ && block != Blocks.f_50718_) continue;
                    return blockPos;
                }
            }
        }
        return null;
    }

    private void plantFlowerFromInv(BlockPos blockPos) {
        if (this.hasFlowers()) {
            SimpleContainer inventory = this.beekeeper.getInventory();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack itemstack = inventory.m_8020_(i);
                boolean flag = false;
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41720_() == Items.f_41939_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50111_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41940_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50112_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41941_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50113_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41942_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50114_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41943_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50115_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41944_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50116_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41945_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50117_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41946_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50118_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41947_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50119_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41948_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50120_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_41950_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50071_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_42206_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50355_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_42207_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50356_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_42208_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50357_.m_49966_(), 3);
                        flag = true;
                    } else if (itemstack.m_41720_() == Items.f_42209_) {
                        this.beekeeper.m_20193_().m_7731_(blockPos, Blocks.f_50358_.m_49966_(), 3);
                        flag = true;
                    }
                }
                if (!flag) continue;
                this.beekeeper.m_20193_().m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                itemstack.m_41774_(1);
                if (!itemstack.m_41619_()) break;
                inventory.m_6836_(i, ItemStack.f_41583_);
                break;
            }
        }
    }
}

