/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities;

import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.config.WorkersModConfig;
import com.talhanation.workers.entities.AbstractChunkLoaderEntity;
import com.talhanation.workers.entities.IBoatController;
import com.talhanation.workers.entities.ai.DepositItemsInChestGoal;
import com.talhanation.workers.entities.ai.EatGoal;
import com.talhanation.workers.entities.ai.SleepGoal;
import com.talhanation.workers.entities.ai.WorkerFloatGoal;
import com.talhanation.workers.entities.ai.WorkerFollowOwnerGoal;
import com.talhanation.workers.entities.ai.WorkerLookAtPlayerGoal;
import com.talhanation.workers.entities.ai.WorkerMoveToHomeGoal;
import com.talhanation.workers.entities.ai.WorkerRandomLookAroundGoal;
import com.talhanation.workers.entities.ai.WorkerUpkeepPosGoal;
import com.talhanation.workers.entities.ai.navigation.SailorPathNavigation;
import com.talhanation.workers.entities.ai.navigation.WorkersPathNavigation;
import com.talhanation.workers.entities.ai.navigation.door.WorkersOpenDoorGoal;
import com.talhanation.workers.inventory.WorkerHireContainer;
import com.talhanation.workers.network.MessageHireGui;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWorkerEntity
extends AbstractChunkLoaderEntity {
    private static final EntityDataAccessor<Optional<BlockPos>> START_POS = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> DEST_POS = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> CHEST = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockPos>> BED = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> FOLLOW = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_WORKING = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> breakingTime = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> currentTimeBreak = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> previousTimeBreak = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HUNGER = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> NEEDS_HOME = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEEDS_CHEST = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEEDS_BED = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PROFESSION_NAME = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> FARMED_ITEMS = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NEEDS_TOOL = SynchedEntityData.m_135353_(AbstractWorkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int hurtTimeStamp = 0;
    public boolean isPickingUp;
    public boolean startPosChanged;

    public AbstractWorkerEntity(EntityType<? extends AbstractWorkerEntity> entityType, Level world) {
        super((EntityType<? extends AbstractChunkLoaderEntity>)entityType, world);
        this.f_21364_ = 2;
        this.m_274367_(1.25f);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new WorkersPathNavigation(this, level);
    }

    @NotNull
    public PathNavigation m_21573_() {
        AbstractWorkerEntity abstractWorkerEntity = this;
        if (abstractWorkerEntity instanceof IBoatController) {
            IBoatController sailor = (IBoatController)((Object)abstractWorkerEntity);
            if (this.m_20202_() instanceof Boat) {
                return new SailorPathNavigation(sailor, this.m_20193_());
            }
        }
        return super.m_21573_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new WorkerUpkeepPosGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new EatGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new WorkerFloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new WorkersOpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new DepositItemsInChestGoal(this));
        this.f_21345_.m_25352_(10, new WorkerMoveToHomeGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new WorkerFollowOwnerGoal(this, 1.0, 20.0));
        this.f_21345_.m_25352_(11, (Goal)new WorkerLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(12, (Goal)new WorkerRandomLookAroundGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new WorkerLookAtPlayerGoal(this, LivingEntity.class, 8.0f));
    }

    public double m_6049_() {
        return -0.35;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_20193_().m_46473_().m_6180_("looting");
        if (!this.m_20193_().f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_20193_(), (Entity)this)) {
            List nearbyItems = this.m_20193_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(5.5, 5.5, 5.5));
            for (ItemEntity itementity : nearbyItems) {
                if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || itementity.m_32063_() || !this.m_7243_(itementity.m_32055_())) continue;
                this.m_7581_(itementity);
            }
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7243_(itemstack)) {
            SimpleContainer inventory = this.getInventory();
            if (!inventory.m_19183_(itemstack)) {
                return;
            }
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            ItemStack itemstack1 = inventory.m_19173_(itemstack);
            if (itemstack1.m_41619_()) {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
                this.increaseFarmedItems();
            }
        }
    }

    public void consumeToolDurability() {
        ItemStack heldItem = this.m_21120_(InteractionHand.MAIN_HAND);
        heldItem.m_41622_(1, (LivingEntity)this, worker -> {
            worker.m_21166_(EquipmentSlot.MAINHAND);
            worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            worker.m_5810_();
            if (worker.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                LivingEntity owner = worker.m_269323_();
                if (owner != null) {
                    worker.tellPlayer(owner, Translatable.TEXT_OUT_OF_TOOLS(heldItem));
                }
                worker.setNeedsTool(true);
            }
        });
        this.upgradeTool();
    }

    public boolean canWorkWithoutTool() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_21203_();
        this.m_5844_();
        if (this.hurtTimeStamp > 0) {
            --this.hurtTimeStamp;
        }
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob creatureentity = (PathfinderMob)entity;
            this.f_20883_ = creatureentity.f_20883_;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance diff, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        return spawnData;
    }

    public void setDropEquipment() {
        this.m_5907_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME, Optional.empty());
        this.f_19804_.m_135372_(START_POS, Optional.empty());
        this.f_19804_.m_135372_(DEST_POS, Optional.empty());
        this.f_19804_.m_135372_(CHEST, Optional.empty());
        this.f_19804_.m_135372_(BED, Optional.empty());
        this.f_19804_.m_135372_(IS_WORKING, (Object)false);
        this.f_19804_.m_135372_(FOLLOW, (Object)false);
        this.f_19804_.m_135372_(NEEDS_HOME, (Object)false);
        this.f_19804_.m_135372_(NEEDS_CHEST, (Object)false);
        this.f_19804_.m_135372_(NEEDS_BED, (Object)false);
        this.f_19804_.m_135372_(NEEDS_TOOL, (Object)false);
        this.f_19804_.m_135372_(breakingTime, (Object)0);
        this.f_19804_.m_135372_(currentTimeBreak, (Object)-1);
        this.f_19804_.m_135372_(previousTimeBreak, (Object)-1);
        this.f_19804_.m_135372_(HUNGER, (Object)Float.valueOf(50.0f));
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(PROFESSION_NAME, (Object)"");
        this.f_19804_.m_135372_(FARMED_ITEMS, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        BlockPos bedPos;
        BlockPos chestPos;
        BlockPos homePos;
        BlockPos destPos;
        super.m_7380_(nbt);
        nbt.m_128379_("Follow", this.getFollow());
        nbt.m_128379_("isWorking", this.getIsWorking());
        nbt.m_128379_("needsHome", this.needsHome());
        nbt.m_128379_("needsChest", this.needsChest());
        nbt.m_128379_("needsTool", this.needsTool());
        nbt.m_128405_("breakTime", this.getBreakingTime());
        nbt.m_128405_("currentTimeBreak", this.getCurrentTimeBreak());
        nbt.m_128405_("previousTimeBreak", this.getPreviousTimeBreak());
        nbt.m_128359_("OwnerName", this.getOwnerName());
        nbt.m_128350_("Hunger", this.getHunger());
        nbt.m_128359_("ProfessionName", this.getProfessionName());
        nbt.m_128405_("FarmedItems", this.getFarmedItems());
        BlockPos startPos = this.getStartPos();
        if (startPos != null) {
            this.setNbtPosition(nbt, "Start", startPos);
        }
        if ((destPos = this.getDestPos()) != null) {
            this.setNbtPosition(nbt, "Dest", destPos);
        }
        if ((homePos = this.getHomePos()) != null) {
            this.setNbtPosition(nbt, "Home", homePos);
        }
        if ((chestPos = this.getChestPos()) != null) {
            this.setNbtPosition(nbt, "Chest", chestPos);
        }
        if ((bedPos = this.getBedPos()) != null) {
            this.setNbtPosition(nbt, "Bed", bedPos);
        }
    }

    public void setNbtPosition(CompoundTag nbt, String blockName, @Nullable BlockPos pos) {
        if (pos == null) {
            return;
        }
        nbt.m_128405_(String.format("%sPosX", blockName), pos.m_123341_());
        nbt.m_128405_(String.format("%sPosY", blockName), pos.m_123342_());
        nbt.m_128405_(String.format("%sPosZ", blockName), pos.m_123343_());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        BlockPos bedPos;
        BlockPos chestPos;
        BlockPos homePos;
        BlockPos destPos;
        super.m_7378_(nbt);
        this.setFollow(nbt.m_128471_("Follow"));
        this.setBreakingTime(nbt.m_128451_("breakTime"));
        this.setNeedsTool(nbt.m_128471_("needsTool"));
        this.setCurrentTimeBreak(nbt.m_128451_("currentTimeBreak"));
        this.setPreviousTimeBreak(nbt.m_128451_("previousTimeBreak"));
        this.setIsWorking(nbt.m_128471_("isWorking"), true);
        this.setHunger(nbt.m_128457_("Hunger"));
        this.setOwnerName(nbt.m_128461_("OwnerName"));
        this.setProfessionName(nbt.m_128461_("ProfessionName"));
        this.setFarmedItems(nbt.m_128451_("FarmedItems"));
        BlockPos startPos = this.getNbtPosition(nbt, "Start");
        if (startPos != null) {
            this.setStartPos(startPos);
        }
        if ((destPos = this.getNbtPosition(nbt, "Dest")) != null) {
            this.setDestPos(destPos);
        }
        if ((homePos = this.getNbtPosition(nbt, "Home")) != null) {
            this.setHomePos(homePos);
        }
        if ((chestPos = this.getNbtPosition(nbt, "Chest")) != null) {
            this.setChestPos(chestPos);
        }
        if ((bedPos = this.getNbtPosition(nbt, "Bed")) != null) {
            this.setBedPos(bedPos);
        }
    }

    public BlockPos getNbtPosition(CompoundTag nbt, String blockName) {
        if (nbt.m_128441_(String.format("%sPosX", blockName)) && nbt.m_128441_(String.format("%sPosY", blockName)) && nbt.m_128441_(String.format("%sPosZ", blockName))) {
            return new BlockPos(nbt.m_128451_(String.format("%sPosX", blockName)), nbt.m_128451_(String.format("%sPosY", blockName)), nbt.m_128451_(String.format("%sPosZ", blockName)));
        }
        return null;
    }

    public int getFarmedItems() {
        return (Integer)this.f_19804_.m_135370_(FARMED_ITEMS);
    }

    public String getProfessionName() {
        return (String)this.f_19804_.m_135370_(PROFESSION_NAME);
    }

    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    @Nullable
    public BlockPos getHomePos() {
        return ((Optional)this.f_19804_.m_135370_(HOME)).orElse(null);
    }

    public boolean needsHome() {
        return (Boolean)this.f_19804_.m_135370_(NEEDS_HOME);
    }

    public boolean needsTool() {
        return (Boolean)this.f_19804_.m_135370_(NEEDS_TOOL);
    }

    @Nullable
    public BlockPos getChestPos() {
        return ((Optional)this.f_19804_.m_135370_(CHEST)).orElse(null);
    }

    public boolean needsChest() {
        return (Boolean)this.f_19804_.m_135370_(NEEDS_CHEST);
    }

    @Nullable
    public BlockPos getBedPos() {
        return ((Optional)this.f_19804_.m_135370_(BED)).orElse(null);
    }

    public boolean needsBed() {
        return (Boolean)this.f_19804_.m_135370_(NEEDS_BED);
    }

    public int getCurrentTimeBreak() {
        return (Integer)this.f_19804_.m_135370_(currentTimeBreak);
    }

    public int getPreviousTimeBreak() {
        return (Integer)this.f_19804_.m_135370_(previousTimeBreak);
    }

    public int getBreakingTime() {
        return (Integer)this.f_19804_.m_135370_(breakingTime);
    }

    public float getHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER)).floatValue();
    }

    public BlockPos getWorkerOnPos() {
        return this.m_20097_();
    }

    public BlockPos getDestPos() {
        return ((Optional)this.f_19804_.m_135370_(DEST_POS)).orElse(null);
    }

    public BlockPos getStartPos() {
        return ((Optional)this.f_19804_.m_135370_(START_POS)).orElse(null);
    }

    public boolean getFollow() {
        return (Boolean)this.f_19804_.m_135370_(FOLLOW);
    }

    public boolean getIsWorking() {
        return (Boolean)this.f_19804_.m_135370_(IS_WORKING);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (((Boolean)WorkersModConfig.WorkersLookLikeVillagers.get()).booleanValue()) {
            return SoundEvents.f_12506_;
        }
        return SoundEvents.f_12323_;
    }

    protected SoundEvent m_5592_() {
        if (((Boolean)WorkersModConfig.WorkersLookLikeVillagers.get()).booleanValue()) {
            return SoundEvents.f_12505_;
        }
        return SoundEvents.f_12322_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected float m_6431_(Pose pos, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean wantsToKeep(ItemStack itemStack) {
        return itemStack.m_41614_() && itemStack.getFoodProperties((LivingEntity)this).m_38744_() > 4;
    }

    public void setFarmedItems(int x) {
        this.f_19804_.m_135381_(FARMED_ITEMS, (Object)x);
    }

    public void setProfessionName(String string) {
        this.f_19804_.m_135381_(PROFESSION_NAME, (Object)string);
    }

    public void setOwnerName(String string) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)string);
    }

    public void setHomePos(BlockPos pos) {
        this.f_19804_.m_135381_(HOME, Optional.of(pos));
    }

    public void setChestPos(BlockPos pos) {
        this.f_19804_.m_135381_(CHEST, Optional.of(pos));
    }

    public void setBedPos(BlockPos pos) {
        this.f_19804_.m_135381_(BED, Optional.of(pos));
    }

    public void setPreviousTimeBreak(int value) {
        this.f_19804_.m_135381_(previousTimeBreak, (Object)value);
    }

    public void setCurrentTimeBreak(int value) {
        this.f_19804_.m_135381_(currentTimeBreak, (Object)value);
    }

    public void setBreakingTime(int value) {
        this.f_19804_.m_135381_(breakingTime, (Object)value);
    }

    public void setHunger(float value) {
        this.f_19804_.m_135381_(HUNGER, (Object)Float.valueOf(value));
    }

    public void setDestPos(BlockPos pos) {
        this.f_19804_.m_135381_(DEST_POS, Optional.of(pos));
    }

    public void setStartPos(BlockPos pos) {
        if (this.getStartPos() != pos) {
            this.startPosChanged = true;
        }
        this.f_19804_.m_135381_(START_POS, Optional.ofNullable(pos));
    }

    public void clearStartPos() {
        this.f_19804_.m_135381_(START_POS, Optional.empty());
    }

    public void setNeedsHome(boolean bool) {
        this.f_19804_.m_135381_(NEEDS_HOME, (Object)bool);
    }

    public void setNeedsTool(boolean bool) {
        if (bool) {
            this.setFarmedItems(64);
        }
        this.f_19804_.m_135381_(NEEDS_TOOL, (Object)bool);
    }

    public void setNeedsChest(boolean bool) {
        this.f_19804_.m_135381_(NEEDS_CHEST, (Object)bool);
    }

    public void setNeedsBed(boolean bool) {
        this.f_19804_.m_135381_(NEEDS_BED, (Object)bool);
    }

    public void setFollow(boolean bool) {
        if (this.getFollow() == bool) {
            return;
        }
        this.f_19804_.m_135381_(FOLLOW, (Object)bool);
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return;
        }
        if (bool) {
            this.tellPlayer(owner, Translatable.TEXT_FOLLOW);
        } else if (this.getIsWorking()) {
            this.tellPlayer(owner, Translatable.TEXT_CONTINUE);
        } else {
            this.tellPlayer(owner, Translatable.TEXT_WANDER);
        }
    }

    public void setIsWorking(boolean bool) {
        LivingEntity owner = this.m_269323_();
        if (this.getIsWorking() != bool) {
            if (owner != null) {
                if (!this.isStarving()) {
                    if (bool) {
                        this.tellPlayer(owner, Translatable.TEXT_WORKING);
                    } else {
                        this.tellPlayer(owner, Translatable.TEXT_DONE);
                    }
                } else if (this.isStarving()) {
                    this.tellPlayer(owner, Translatable.TEXT_STARVING);
                    this.f_19804_.m_135381_(IS_WORKING, (Object)false);
                }
            }
            this.f_19804_.m_135381_(IS_WORKING, (Object)bool);
        }
    }

    public void setIsWorking(boolean bool, boolean withoutFeedback) {
        if (withoutFeedback) {
            this.f_19804_.m_135381_(IS_WORKING, (Object)bool);
        } else {
            this.setIsWorking(bool);
        }
    }

    public void setOwned(boolean owned) {
        super.m_7105_(owned);
    }

    public void setEquipment() {
    }

    public boolean m_6469_(DamageSource dmg, float amt) {
        String name = this.m_5446_().getString();
        if (this.m_6673_(dmg)) {
            return false;
        }
        Entity entity = dmg.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amt = (amt + 1.0f) / 2.0f;
        }
        LivingEntity attacker = this.m_21188_();
        if (this.m_21824_() && attacker != null && this.hurtTimeStamp <= 0) {
            String attacker_name = attacker.m_5446_().getString();
            LivingEntity owner = this.m_269323_();
            if (owner != null && owner != attacker) {
                this.tellPlayer(owner, Translatable.TEXT_ATTACKED(name, attacker_name));
                this.hurtTimeStamp = 80;
            }
        }
        return super.m_6469_(dmg, amt);
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    @Override
    public void m_6667_(@NotNull DamageSource dmg) {
        super.m_6667_(dmg);
    }

    public boolean needsToSleep() {
        return !this.m_20193_().m_46461_();
    }

    public void updateHunger() {
        if (this.getHunger() > 0.0f) {
            this.setHunger(this.getHunger() - 1.0E-4f);
            if (this.getIsWorking()) {
                this.setHunger(this.getHunger() - 2.0E-4f);
            }
            if (this.getBedPos() == null) {
                this.setHunger(this.getHunger() - 2.0E-4f);
            }
        }
        if (this.isStarving() && this.getIsWorking()) {
            this.setIsWorking(false);
        }
    }

    public void tellPlayer(LivingEntity player, Component message) {
        if (((Boolean)WorkersModConfig.OwnerReceiveInfo.get()).booleanValue()) {
            MutableComponent dialogue = Component.m_237113_((String)this.m_7755_().getString()).m_130946_(": ").m_7220_(message);
            player.m_213846_((Component)dialogue);
        }
    }

    public void walkTowards(BlockPos pos, double speed) {
        if (pos != null) {
            this.m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), speed);
            this.m_21563_().m_24950_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 10.0f, (float)this.m_8132_());
        }
    }

    public boolean needsToGetFood() {
        boolean isChest = this.getChestPos() != null;
        return this.needsToEat() && isChest;
    }

    public boolean needsToEat() {
        return this.getHunger() <= 50.0f || (double)this.m_21223_() < (double)this.m_21233_() * 0.2 || this.isStarving();
    }

    public boolean isStarving() {
        return this.getHunger() <= 1.0f;
    }

    public boolean isSaturated() {
        return this.getHunger() >= 90.0f;
    }

    public void resetWorkerParameters() {
        this.resetFarmedItems();
        this.setBreakingTime(0);
        this.setCurrentTimeBreak(-1);
        this.setPreviousTimeBreak(-1);
    }

    public boolean canWork() {
        boolean canNotWorkWithTool = this.needsTool() && !this.canWorkWithoutTool();
        boolean noStartPos = this.getStartPos() == null;
        boolean needsToSleep = this.needsToSleep();
        boolean isFollowing = this.getFollow();
        boolean needsToDeposit = this.needsToDeposit();
        boolean needsToGetFood = this.needsToGetFood();
        boolean isWorkingActive = this.getIsWorking();
        if (canNotWorkWithTool || noStartPos || needsToSleep || isFollowing || needsToDeposit || needsToGetFood || this.startPosChanged) {
            this.startPosChanged = false;
            return false;
        }
        return isWorkingActive;
    }

    public boolean needsToDeposit() {
        return (this.needsTool() || this.getFarmedItems() >= 64) && this.getChestPos() != null && !this.getFollow() && !this.needsChest() && !this.needsToSleep();
    }

    public void increaseFarmedItems() {
        this.setFarmedItems(this.getFarmedItems() + 1);
    }

    public void resetFarmedItems() {
        this.setFarmedItems(0);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public abstract int workerCosts();

    public boolean m_35506_() {
        return false;
    }

    protected void m_21834_(boolean smoke) {
    }

    public void workerSwingArm() {
        if (!this.f_20911_) {
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_20193_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (this.m_21824_() && player.m_20148_().equals(this.m_21805_())) {
            if (player.m_6047_()) {
                this.openGUI(player);
            }
            if (!player.m_6047_()) {
                this.setFollow(!this.getFollow());
                return InteractionResult.SUCCESS;
            }
        } else if (this.m_21824_() && !player.m_20148_().equals(this.m_21805_())) {
            this.tellPlayer((LivingEntity)player, Translatable.TEXT_HELLO_OWNED(this.getProfessionName(), this.getOwnerName()));
        } else if (!this.m_21824_()) {
            this.tellPlayer((LivingEntity)player, Translatable.TEXT_HELLO(this.getProfessionName()));
            this.openHireGUI(player);
            this.f_21344_.m_26573_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hire(Player player) {
        this.makeHireSound();
        this.m_21828_(player);
        this.setOwnerName(player.m_5446_().getString());
        this.m_21839_(false);
        this.m_21816_(player.m_20148_());
        this.setOwned(true);
        this.setFollow(true);
        this.f_21344_.m_26573_();
        int i = this.f_19796_.m_188503_(4);
        switch (i) {
            case 1: {
                this.tellPlayer((LivingEntity)player, Translatable.TEXT_RECRUITED1);
                break;
            }
            case 2: {
                this.tellPlayer((LivingEntity)player, Translatable.TEXT_RECRUITED2);
                break;
            }
            case 3: {
                this.tellPlayer((LivingEntity)player, Translatable.TEXT_RECRUITED3);
            }
        }
        this.tellOtherVillagersIWasHired(player);
        return true;
    }

    public void makeHireSound() {
        this.m_20193_().m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), (Boolean)WorkersModConfig.WorkersLookLikeVillagers.get() != false ? SoundEvents.f_12503_ : SoundEvents.f_12320_, this.m_5720_(), 15.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
    }

    private void tellOtherVillagersIWasHired(Player player) {
        Level level = this.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_45971_(Villager.class, null, (LivingEntity)this, this.m_20191_()).forEach(villager -> server.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager));
        }
    }

    public abstract Predicate<ItemEntity> getAllowedItems();

    public abstract void openGUI(Player var1);

    public void initSpawn() {
        this.setEquipment();
        this.setDropEquipment();
        this.m_21530_();
        this.m_21553_(true);
    }

    public void openHireGUI(Player player) {
        this.f_21344_.m_26573_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuProvider containerSupplier = new MenuProvider(){

                public Component m_5446_() {
                    return AbstractWorkerEntity.this.m_7770_();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new WorkerHireContainer(i, playerInventory.f_35978_, AbstractWorkerEntity.this, playerInventory);
                }
            };
            Consumer<FriendlyByteBuf> extraDataWriter = packetBuffer -> packetBuffer.m_130077_(this.m_20148_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, extraDataWriter);
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageHireGui(player, this.m_20148_()));
        }
    }

    public double getDistanceToOwner() {
        return this.m_269323_() != null ? this.m_20280_((Entity)this.m_269323_()) : 1.0;
    }

    public abstract boolean isRequiredMainTool(ItemStack var1);

    public abstract boolean isRequiredSecondTool(ItemStack var1);

    public boolean hasMainToolInInv() {
        SimpleContainer inventory = this.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!this.isRequiredMainTool(itemStack)) continue;
            return true;
        }
        return false;
    }
}

