/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.talhanation.workers.Main;
import com.talhanation.workers.client.gui.WorkerInventoryScreen;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import com.talhanation.workers.network.MessageMineDepth;
import com.talhanation.workers.network.MessageMineType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class MinerInventoryScreen
extends WorkerInventoryScreen {
    private final MinerEntity miner;
    private int mineType;
    private int mineDepth;
    private static final int fontColor = 0x404040;
    private final MutableComponent MINEMODE = Component.m_237115_((String)"gui.workers.miner.mine_mode");
    private final MutableComponent TUNNEL = Component.m_237115_((String)"gui.workers.miner.tunnel");
    private final MutableComponent TUNNEL3x3 = Component.m_237115_((String)"gui.workers.miner.tunnel3x3");
    private final MutableComponent PIT8x8x8 = Component.m_237115_((String)"gui.workers.miner.pit8x8x8");
    private final MutableComponent FLAT8x8x1 = Component.m_237115_((String)"gui.workers.miner.flat8x8x1");
    private final MutableComponent ROOM8x8x3 = Component.m_237115_((String)"gui.workers.miner.room8x8x3");
    private final MutableComponent PIT16x16x16 = Component.m_237115_((String)"gui.workers.miner.pit16x16x16");
    private final MutableComponent FLAT16x16x1 = Component.m_237115_((String)"gui.workers.miner.flat16x16x1");
    private final MutableComponent ROOM16x16x3 = Component.m_237115_((String)"gui.workers.miner.room16x16x3");
    private final MutableComponent DEPTH = Component.m_237115_((String)"gui.workers.miner.depth");
    private final MutableComponent WANDERING = Component.m_237115_((String)"gui.workers.following");
    private final MutableComponent FOLLOWING = Component.m_237115_((String)"gui.workers.wandering");

    public MinerInventoryScreen(WorkerInventoryContainer container, Inventory playerInventory, Component title) {
        super(container, playerInventory, (Component)Component.m_237113_((String)""));
        this.miner = (MinerEntity)container.getWorker();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 90, this.f_97736_ + 60, 12, 12, (Component)Component.m_237113_((String)"<"), button -> {
            this.mineType = this.miner.getMineType();
            if (this.mineType != 0) {
                --this.mineType;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMineType(this.mineType, this.miner.m_20148_()));
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 90 + 70, this.f_97736_ + 60, 12, 12, (Component)Component.m_237113_((String)">"), button -> {
            this.mineType = this.miner.getMineType();
            if (this.mineType != 8) {
                ++this.mineType;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMineType(this.mineType, this.miner.m_20148_()));
            }
        }));
        ExtendedButton button1 = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 10, this.f_97736_ + 60, 12, 12, (Component)Component.m_237113_((String)"<"), button -> {
            if (this.miner.getMineType() < 3) {
                this.mineDepth = this.miner.getMineDepth();
                if (this.mineDepth != 0) {
                    --this.mineDepth;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMineDepth(this.mineDepth, this.miner.m_20148_()));
                }
            }
        }));
        ExtendedButton button2 = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 10 + 30, this.f_97736_ + 60, 12, 12, (Component)Component.m_237113_((String)">"), button -> {
            if (this.miner.getMineType() < 3) {
                this.mineDepth = this.miner.getMineDepth();
                if (this.mineDepth != this.miner.getMaxMineDepth()) {
                    ++this.mineDepth;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMineDepth(this.mineDepth, this.miner.m_20148_()));
                }
            }
        }));
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int k = 79;
        int l = 19;
        String depth = this.miner.getMineType() >= 3 ? "-" : String.valueOf(this.miner.getMineDepth());
        guiGraphics.m_280056_(this.f_96547_, this.DEPTH.getString() + ":", k - 70, l + 35, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, depth, k - 55, l + 45, 0x404040, false);
        String type = switch (this.miner.getMineType()) {
            default -> {
                if (this.miner.getFollow()) {
                    yield this.FOLLOWING.getString();
                }
                yield this.WANDERING.getString();
            }
            case 1 -> this.TUNNEL.getString();
            case 2 -> this.TUNNEL3x3.getString();
            case 3 -> this.PIT8x8x8.getString();
            case 4 -> this.FLAT8x8x1.getString();
            case 5 -> this.ROOM8x8x3.getString();
            case 6 -> this.PIT16x16x16.getString();
            case 7 -> this.FLAT16x16x1.getString();
            case 8 -> this.ROOM16x16x3.getString();
        };
        guiGraphics.m_280056_(this.f_96547_, this.MINEMODE.getString() + ":", k + 25, l + 35, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, type, k + 25, l + 45, 0x404040, false);
    }
}

