/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.inventory.MerchantInventoryContainer;
import com.talhanation.workers.network.MessageMerchantHorse;
import com.talhanation.workers.network.MessageMerchantResetCurrentTradeCounts;
import com.talhanation.workers.network.MessageMerchantSetCreative;
import com.talhanation.workers.network.MessageMerchantTradeLimitButton;
import com.talhanation.workers.network.MessageOpenWaypointsGuiMerchant;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class MerchantOwnerScreen
extends ScreenBase<MerchantInventoryContainer> {
    private static final ResourceLocation GUI_TEXTURE_3 = new ResourceLocation("workers", "textures/gui/merchant_owner_gui.png");
    private static final int fontColor = 0x404040;
    public static List<Integer> currentTrades;
    public static List<Integer> limits;
    private final MerchantEntity merchant;
    private final Inventory playerInventory;
    private final Player player;

    public MerchantOwnerScreen(MerchantInventoryContainer container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE_3, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.merchant = (MerchantEntity)container.getWorker();
        this.playerInventory = playerInventory;
        this.player = playerInventory.f_35978_;
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setUpdatableButtons();
        int zeroLeftPos = this.f_97735_ + 180;
        int zeroTopPos = this.f_97736_ - 30;
        int mirror = 180;
        this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - mirror + 180, zeroTopPos + 35, 41, 20, (Component)Component.m_237113_((String)"Travel"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenWaypointsGuiMerchant(this.player, this.merchant.m_20148_()))));
        if (this.player.m_7500_() && this.player.m_20203_().m_6761_(4)) {
            this.createCreativeButton(zeroLeftPos - mirror - 45, zeroTopPos + 35);
        }
        this.createTradeLimitButtons(zeroLeftPos - mirror + 130, zeroTopPos + 48, 0);
        this.createTradeLimitButtons(zeroLeftPos - mirror + 130, zeroTopPos + 48, 1);
        this.createTradeLimitButtons(zeroLeftPos - mirror + 130, zeroTopPos + 48, 2);
        this.createTradeLimitButtons(zeroLeftPos - mirror + 130, zeroTopPos + 48, 3);
    }

    public void setUpdatableButtons() {
        int zeroLeftPos = this.f_97735_ + 180;
        int zeroTopPos = this.f_97736_ - 30;
        int mirror = 180;
        this.createHorseButton(zeroLeftPos - mirror + 180, zeroTopPos + 60);
    }

    private void createHorseButton(int x, int y) {
        String dis_mount = this.merchant.m_20202_() != null ? "Dismount" : "Mount";
        this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 41, 20, (Component)Component.m_237113_((String)dis_mount), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantHorse(this.merchant.m_20148_()));
            this.setUpdatableButtons();
        }));
    }

    private void createCreativeButton(int x, int y) {
        this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 41, 20, (Component)Component.m_237113_((String)"Creative"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetCreative(this.merchant.m_20148_(), !this.merchant.isCreative()));
            this.setUpdatableButtons();
        }));
    }

    private void createTradeLimitButtons(int x, int y, int index) {
        this.m_142416_((GuiEventListener)new ExtendedButton(x, y + 18 * index, 12, 12, (Component)Component.m_237113_((String)"+"), button -> {
            int limit = limits.get(index);
            limit = this.player.m_6144_() ? (limit += 5) : ++limit;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTradeLimitButton(index, limit, this.merchant.m_20148_()));
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(13 + x, y + 18 * index, 12, 12, (Component)Component.m_237113_((String)"-"), button -> {
            int limit = limits.get(index);
            limit = this.player.m_6144_() ? (limit -= 5) : --limit;
            if (limit < -1) {
                limit = -1;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTradeLimitButton(index, limit, this.merchant.m_20148_()));
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(26 + x, y + 18 * index, 12, 12, (Component)Component.m_237113_((String)"0"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantResetCurrentTradeCounts(this.merchant.m_20148_()))));
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.merchant.m_5446_().m_7532_(), 8, 6, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInventory.m_5446_().m_7532_(), 8, this.f_97727_ - 152 + 59, 0x404040, false);
        if (limits != null && currentTrades != null) {
            for (int i = 0; i < limits.size(); ++i) {
                int limit = limits.get(i);
                if (limit != -1) {
                    guiGraphics.m_280056_(this.f_96547_, currentTrades.get(i) + "/" + limits.get(i), 103, 21 + i * 18, 0x404040, false);
                    continue;
                }
                guiGraphics.m_280056_(this.f_96547_, currentTrades.get(i) + "/\u221e", 103, 21 + i * 18, 0x404040, false);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
    }
}

