/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LuckAppendTableLootModifier
extends LootModifier {
    public static final Codec<LuckAppendTableLootModifier> CODEC = RecordCodecBuilder.create(i -> LuckAppendTableLootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.DOUBLE.fieldOf("chance").forGetter(e -> e.chance), (App)Codec.DOUBLE.fieldOf("bonus").forGetter(e -> e.bonus), (App)Codec.STRING.fieldOf("table").forGetter(e -> e.table.toString()))).apply((Applicative)i, LuckAppendTableLootModifier::new));
    private final double chance;
    private final double bonus;
    private final ResourceLocation table;

    private LuckAppendTableLootModifier(LootItemCondition[] conditionsIn, double chance, double bonus, String table) {
        super(conditionsIn);
        this.chance = chance;
        this.bonus = bonus;
        this.table = new ResourceLocation(table);
    }

    public LuckAppendTableLootModifier(double chance, double bonus, ResourceLocation table, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.chance = chance;
        this.bonus = bonus;
        this.table = table;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        int count;
        double luckFactor = (Double)CoPConfig.COMMON.lootLuckFactor.get();
        double total = this.chance + this.bonus * luckFactor * (double)context.m_78945_();
        if (total - (double)(count = (int)total) > context.m_230907_().m_188500_()) {
            ++count;
        }
        int maxItem = (Integer)CoPConfig.COMMON.maxItemGenerated.get();
        count = Math.min(maxItem, count);
        for (int i = 0; i < count; ++i) {
            this.add(list, context);
        }
        return list;
    }

    private void add(ObjectArrayList<ItemStack> list, LootContext context) {
        LootTable lootTable = context.m_78952_().m_7654_().m_278653_().m_278676_(this.table);
        ObjectArrayList objectarraylist = new ObjectArrayList();
        lootTable.m_79131_(context, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        list.addAll((ObjectList)objectarraylist);
    }

    public Codec<LuckAppendTableLootModifier> codec() {
        return CODEC;
    }
}

