/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.init.loot;

import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootGen {
    private static LootPoolSingletonContainer.Builder<?> getItem(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    private static ItemEntry<?>[] attr() {
        return new ItemEntry[]{CoPItems.CHARM_HEALTH, CoPItems.CHARM_ARMOR, CoPItems.CHARM_SPEED, CoPItems.CHARM_DAMAGE, CoPItems.CHARM_HEAVY, CoPItems.CHARM_ACCURACY, CoPItems.CHARM_CRIT, CoPItems.CHARM_BOW, CoPItems.CHARM_PROTECTION, CoPItems.CHARM_MAGIC, CoPItems.CHARM_EXPLOSION, CoPItems.CHARM_LUCK};
    }

    private static ItemEntry<?>[] angelic() {
        return new ItemEntry[]{CoPItems.ANGELIC_WING, CoPItems.ANGELIC_BLESS, CoPItems.ANGELIC_DESCENT, CoPItems.ANGELIC_PROTECTION, CoPItems.ANGELIC_PUNISHMENT};
    }

    private static ItemEntry<?>[] hell() {
        return new ItemEntry[]{CoPItems.HELLFIRE_SKULL, CoPItems.HELLFIRE_REFORMATION, CoPItems.EYE_OF_CURSED_SOULS, CoPItems.CURSED_SOUL_CRYSTAL, CoPItems.CROWN_OF_DEMON};
    }

    private static ItemEntry<?>[] shadow() {
        return new ItemEntry[]{CoPItems.SHADOW_CORE, CoPItems.SHADOW_CONVERGENCE, CoPItems.SHADOW_CONSOLIDATION, CoPItems.SHADOW_REFORMATION, CoPItems.VOID_OVERFLOW};
    }

    private static ItemEntry<?>[] abyssal() {
        return new ItemEntry[]{CoPItems.ABYSSAL_TREASURE, CoPItems.ABYSSAL_WATCHER, CoPItems.ABYSSAL_SHELL, CoPItems.ABYSSAL_CROWN, CoPItems.ABYSSAL_WILL};
    }

    private static ItemEntry<?>[] barbaric() {
        return new ItemEntry[]{CoPItems.BARBARIC_INSTINCT, CoPItems.BARBARIC_WRATH, CoPItems.BARBARIC_ROAR, CoPItems.BARBARIC_BLADE, CoPItems.PRIMAL_FORCE};
    }

    private static ItemEntry<?>[] evil() {
        return new ItemEntry[]{CoPItems.EVIL_SPIRIT_RITUAL, CoPItems.EVIL_SPIRIT_EVOKE, CoPItems.EVIL_SPIRIT_AWAKENING, CoPItems.EVIL_SPIRIT_CURSE, CoPItems.EVIL_SPIRIT_WALK};
    }

    private static ItemEntry<?>[] elemental() {
        return new ItemEntry[]{CoPItems.WIND_THRUST, CoPItems.EARTH_CRUSH, CoPItems.FLAMING_EXPLOSION, CoPItems.WAVING_SPELL, CoPItems.CURSE_REDIRECTION};
    }

    private static LootTable.Builder buildPlaceholderLoot() {
        return new PoolBuilder().fromTag(100, LootGen.attr()).build();
    }

    private static void genInnerLoot(BiConsumer<ResourceLocation, LootTable.Builder> map) {
        for (LootDefinition def : LootDefinition.values()) {
            map.accept(def.getInner(), def.loot.get());
        }
    }

    public static void genLoot(RegistrateLootTableProvider pvd) {
        pvd.addLootAction(LootContextParamSets.f_81410_, LootGen::genInnerLoot);
    }

    private static class PoolBuilder {
        private final LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.0f));

        private PoolBuilder() {
        }

        private PoolBuilder addItems(LootEntry entry) {
            for (Item e : entry.items) {
                this.pool.m_79076_(LootGen.getItem(e, entry.weight));
            }
            return this;
        }

        private PoolBuilder addItem(int weight, Item item) {
            this.pool.m_79076_(LootGen.getItem(item, weight));
            return this;
        }

        private PoolBuilder fromTag(int weight, ItemEntry<?>[] tag) {
            return this.addItems(new LootEntry(weight, (Item[])Arrays.stream(tag).map(RegistryEntry::get).toArray(Item[]::new)));
        }

        private LootTable.Builder build() {
            return LootTable.m_79147_().m_79161_(this.pool);
        }
    }

    public static enum LootDefinition {
        END_CITY_TREASURE(0.2, 0.1, BuiltInLootTables.f_78741_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.shadow()).addItem(200, (Item)CoPItems.ENDER_CHARM.get()).build()),
        NETHER_BRIDGE(0.2, 0.1, BuiltInLootTables.f_78760_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.hell()).addItem(200, (Item)CoPItems.BLESS_LAVA_WALKER.get()).build()),
        RUINED_PORTAL(0.2, 0.1, BuiltInLootTables.f_78701_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).addItem(200, (Item)CoPItems.BLESS_LAVA_WALKER.get()).addItem(200, (Item)CoPItems.GOLDEN_HEART.get()).build()),
        BASTION_TREASURE(1.0, 0.2, BuiltInLootTables.f_78697_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.hell()).addItem(200, (Item)CoPItems.BLESS_LAVA_WALKER.get()).addItem(200, (Item)CoPItems.GOLDEN_HEART.get()).addItem(200, (Item)CoPItems.STABLE_BODY.get()).build()),
        BASTION_OTHER(0.2, 0.1, BuiltInLootTables.f_78698_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(25, LootGen.hell()).fromTag(25, LootGen.barbaric()).addItem(200, (Item)CoPItems.BLESS_LAVA_WALKER.get()).addItem(200, (Item)CoPItems.GOLDEN_HEART.get()).addItem(200, (Item)CoPItems.STABLE_BODY.get()).build()),
        BASTION_BRIDGE(0.2, 0.1, BuiltInLootTables.f_78699_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.barbaric()).addItem(200, (Item)CoPItems.BLESS_LAVA_WALKER.get()).addItem(200, (Item)CoPItems.GOLDEN_HEART.get()).addItem(200, (Item)CoPItems.STABLE_BODY.get()).build()),
        IGLOO_CHEST(0.2, 0.1, BuiltInLootTables.f_78688_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).addItem(400, (Item)CoPItems.BLESS_SNOW_WALKER.get()).build()),
        ANCIENT_CITY(0.4, 0.2, BuiltInLootTables.f_230876_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.abyssal()).build()),
        WOODLAND_MANSION(0.4, 0.2, BuiltInLootTables.f_78689_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.evil()).build()),
        PILLAGER_OUTPOST(0.2, 0.1, BuiltInLootTables.f_78696_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(25, LootGen.evil()).fromTag(25, LootGen.elemental()).build()),
        DESERT_PYRAMID(0.2, 0.1, BuiltInLootTables.f_78764_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.angelic()).build()),
        JUNGLE_TEMPLE(0.2, 0.1, BuiltInLootTables.f_78686_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.angelic()).build()),
        UNDERWATER_RUIN_BIG(0.2, 0.1, BuiltInLootTables.f_78691_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.angelic()).build()),
        SHIPWRECK_TREASURE(0.2, 0.1, BuiltInLootTables.f_78695_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.elemental()).build()),
        STRONGHOLD_CORRIDOR(0.2, 0.1, BuiltInLootTables.f_78763_, () -> new PoolBuilder().fromTag(100, LootGen.attr()).fromTag(50, LootGen.elemental()).build()),
        ABANDONED_MINESHAFT(0.1, 0.05, BuiltInLootTables.f_78759_, LootGen::buildPlaceholderLoot),
        SIMPLE_DUNGEON(0.1, 0.05, BuiltInLootTables.f_78742_, LootGen::buildPlaceholderLoot),
        VILLAGE_TEMPLE(0.1, 0.05, BuiltInLootTables.f_78753_, LootGen::buildPlaceholderLoot);

        public final String id;
        public final double chance;
        public final double bonus;
        public final ResourceLocation table;
        public final Supplier<LootTable.Builder> loot;

        private LootDefinition(double chance, double bonus, ResourceLocation table, Supplier<LootTable.Builder> loot) {
            this.chance = chance;
            this.bonus = bonus;
            this.table = table;
            this.id = this.name().toLowerCase(Locale.ROOT);
            this.loot = loot;
        }

        public ResourceLocation getInner() {
            return new ResourceLocation("curseofpandora", this.id);
        }
    }

    private record LootEntry(int weight, Item[] items) {
    }
}

