/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.init;

import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.curseofpandora.compat.CoPLoader;
import dev.xkmc.curseofpandora.compat.CoPTraits;
import dev.xkmc.curseofpandora.event.ItemClickListener;
import dev.xkmc.curseofpandora.event.PandoraAttackListener;
import dev.xkmc.curseofpandora.init.data.CoPAdvGen;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPConfigGen;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.data.CoPRecipeGen;
import dev.xkmc.curseofpandora.init.data.CoPSlotGen;
import dev.xkmc.curseofpandora.init.data.CoPTagGen;
import dev.xkmc.curseofpandora.init.data.CurseIngredient;
import dev.xkmc.curseofpandora.init.loot.CoPGLMProvider;
import dev.xkmc.curseofpandora.init.loot.LootDataToClient;
import dev.xkmc.curseofpandora.init.loot.LootGen;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.curseofpandora.init.registrate.CoPEntities;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2complements.events.ItemUseEventHandler;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.init.events.EffectSyncEvents;
import dev.xkmc.l2library.serial.config.PacketHandlerWithConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="curseofpandora")
@Mod.EventBusSubscriber(modid="curseofpandora", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CurseOfPandora {
    public static final String MODID = "curseofpandora";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE;
    public static final PacketHandlerWithConfig HANDLER;

    public CurseOfPandora() {
        CoPItems.register();
        CoPEffects.register();
        CoPAttrs.register();
        CoPEntities.register();
        CoPGLMProvider.register();
        CoPConfig.init();
        if (ModList.get().isLoaded("l2hostility")) {
            CoPTraits.register();
        }
        AttackEventHandler.register((int)5200, (AttackListener)new PandoraAttackListener());
        REGISTRATE.addDataGenerator(ProviderType.LANG, CoPLangData::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, CoPRecipeGen::recipeGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CoPTagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, CoPTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(TagGen.EFF_TAGS, CoPTagGen::onEffectTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, CoPAdvGen::onAdvGen);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, LootGen::genLoot);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ItemUseEventHandler.LIST.add(new ItemClickListener());
            EffectSyncEvents.TRACKED.add((MobEffect)CoPEffects.SHADOW.get());
        });
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)CoPAttrs.SPELL.get());
        event.add(EntityType.f_20532_, (Attribute)CoPAttrs.REALITY.get());
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean run = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(run, (DataProvider)new CoPConfigGen(gen));
        new CoPDamageTypeGen(output, pvd, helper).generate(run, gen);
        gen.addProvider(run, (DataProvider)new CoPGLMProvider(output));
        gen.addProvider(run, (DataProvider)new CoPSlotGen(gen));
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((ResourceLocation)CurseIngredient.INSTANCE.id(), CurseIngredient.INSTANCE);
        }
    }

    static {
        HANDLER = new PacketHandlerWithConfig(new ResourceLocation(MODID, "main"), 2, new Function[]{e -> e.create(LootDataToClient.class, NetworkDirection.PLAY_TO_CLIENT)});
        REGISTRATE = ModList.get().isLoaded("l2hostility") ? CoPLoader.getLHRegistrate(MODID) : new L2Registrate(MODID);
    }
}

