/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.weapon;

import dev.xkmc.curseofpandora.content.entity.WindBladeEntity;
import dev.xkmc.curseofpandora.content.entity.WindBladeWeapon;
import dev.xkmc.curseofpandora.content.weapon.EmptyClickListener;
import dev.xkmc.curseofpandora.content.weapon.WeaponTier;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.init.explosion.BaseExplosion;
import dev.xkmc.l2library.init.explosion.BaseExplosionContext;
import dev.xkmc.l2library.init.explosion.ExplosionHandler;
import dev.xkmc.l2library.init.explosion.VanillaExplosionContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CursedKarma
extends SwordItem
implements EmptyClickListener,
WindBladeWeapon {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.weapon.cursedKarmaRealityIndex.get();
    }

    public static int getRadius() {
        return (Integer)CoPConfig.COMMON.weapon.cursedKarmaExplosionRadius.get();
    }

    public static int getDuration() {
        return (Integer)CoPConfig.COMMON.weapon.cursedKarmaEffectDuration.get();
    }

    public CursedKarma(Item.Properties props) {
        super((Tier)WeaponTier.CURSED_KARMA, 10, -2.4f, props);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= CursedKarma.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(CursedKarma.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Weapon.CURSED_KARMA.get(new Object[0]).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void clickEmpty(ItemStack stack, Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) < (double)CursedKarma.getIndexReq()) {
            return;
        }
        float strength = player.m_36403_(0.5f);
        if (strength < 0.9f) {
            return;
        }
        player.m_36334_();
        Level level = player.m_9236_();
        float velocity = 1.0f;
        float dist = 64.0f;
        float dmg = (float)player.m_21133_(Attributes.f_22281_);
        float f = (float)(player.m_217043_().m_188500_() * 360.0);
        if (!level.m_5776_()) {
            WindBladeEntity e = new WindBladeEntity(level);
            e.m_5602_((Entity)player);
            e.m_6034_(player.m_20185_(), player.m_20188_() - 0.5, player.m_20189_());
            e.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity, 0.0f);
            e.setProperties(dmg, Math.round(dist / velocity), f, stack);
            level.m_7967_((Entity)e);
        }
    }

    @Override
    public DamageSource getSource(WindBladeEntity entity, @Nullable Entity owner) {
        return new DamageSource(CoPDamageTypeGen.forKey(entity.m_9236_(), CoPDamageTypeGen.SOUL_CURSE), (Entity)entity, owner);
    }

    @Override
    public void onHit(WindBladeEntity entity) {
        Vec3 pos = entity.m_20182_();
        BaseExplosionContext base = new BaseExplosionContext(entity.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)CursedKarma.getRadius());
        VanillaExplosionContext mc = new VanillaExplosionContext((Entity)entity, null, (ExplosionDamageCalculator)null, false, Explosion.BlockInteraction.KEEP);
        ExplosionHandler.explode((BaseExplosion)new BaseExplosion(base, mc, e -> this.isTarget(e, entity.m_19749_())));
        entity.m_146870_();
    }

    private boolean isTarget(Entity entity, Entity owner) {
        if (owner != null) {
            if (entity == owner) {
                return false;
            }
            if (entity.m_7307_(owner)) {
                return false;
            }
            if (owner.m_7307_(entity)) {
                return false;
            }
        }
        int duration = CursedKarma.getDuration();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                EffectUtil.addEffect((LivingEntity)le, (MobEffectInstance)new MobEffectInstance((MobEffect)LCEffects.FLAME.get(), duration), (EffectUtil.AddReason)EffectUtil.AddReason.FORCE, (Entity)player);
                EffectUtil.addEffect((LivingEntity)le, (MobEffectInstance)new MobEffectInstance((MobEffect)LCEffects.CURSE.get(), duration), (EffectUtil.AddReason)EffectUtil.AddReason.FORCE, (Entity)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean glow() {
        return true;
    }

    @Override
    public ResourceLocation bladeTexture() {
        return new ResourceLocation("curseofpandora", "textures/entity/flame_blade.png");
    }

    @Override
    public ParticleOptions getParticle() {
        return DustColorTransitionOptions.f_175752_;
    }
}

