/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.shadow;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowReformation
extends ITokenProviderItem<Data> {
    public static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.shadow.shadowReformationRealityIndex.get();
    }

    public static double getBonus() {
        return (Double)CoPConfig.COMMON.shadow.shadowReformationBonus.get();
    }

    public static double getReduction() {
        return (Double)CoPConfig.COMMON.shadow.shadowReformationReduction.get();
    }

    public ShadowReformation(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= ShadowReformation.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(ShadowReformation.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Shadow.REFORMATION_1.get(Math.round(ShadowReformation.getBonus() * 100.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Shadow.REFORMATION_2.get(Math.round(ShadowReformation.getReduction() * 100.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)ShadowReformation.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
        }

        @Override
        public void onPlayerHurtTarget(Player player, AttackCache cache) {
            if (!cache.getAttackTarget().m_21023_((MobEffect)CoPEffects.SHADOW.get())) {
                return;
            }
            LivingHurtEvent event = cache.getLivingHurtEvent();
            assert (event != null);
            if (event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + ShadowReformation.getBonus()))));
            }
        }

        @Override
        public void onPlayerDamaged(Player player, AttackCache cache) {
            if (cache.getAttacker() == null || !cache.getAttacker().m_21023_((MobEffect)CoPEffects.SHADOW.get())) {
                return;
            }
            LivingDamageEvent event = cache.getLivingDamageEvent();
            assert (event != null);
            if (!(event.getSource().m_269533_(L2DamageTypes.MAGIC) || event.getSource().m_269533_(DamageTypeTags.f_268437_) || event.getSource().m_269533_(DamageTypeTags.f_268738_))) {
                cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - ShadowReformation.getReduction()))));
            }
        }
    }
}

