/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.shadow;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowCore
extends ITokenProviderItem<Data> {
    public static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.shadow.shadowCoreRealityIndex.get();
    }

    public static int getDuration() {
        return (Integer)CoPConfig.COMMON.shadow.shadowCoreDurationPerIndex.get();
    }

    public static double getFactor() {
        return (Double)CoPConfig.COMMON.shadow.damageReduction.get();
    }

    public ShadowCore(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= ShadowCore.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(ShadowCore.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Shadow.CORE_1.get(Math.round((double)ShadowCore.getDuration() / 20.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)CoPLangData.Shadow.CORE_2.get(Math.round(ShadowCore.getFactor() * 100.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)ShadowCore.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
        }

        @Override
        public void onPlayerHurtTarget(Player player, AttackCache cache) {
            LivingEntity target = cache.getAttackTarget();
            int index = (int)Math.round(player.m_21133_((Attribute)CoPAttrs.REALITY.get()));
            int time = ShadowCore.getDuration() * index;
            GeneralEventHandler.schedule(() -> EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)new MobEffectInstance((MobEffect)CoPEffects.SHADOW.get(), time), (EffectUtil.AddReason)EffectUtil.AddReason.FORCE, (Entity)player));
        }
    }
}

