/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.hell;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CrownOfDemon
extends ITokenProviderItem<Data> {
    public static boolean check(Player player) {
        return ((ConditionalData)ConditionalData.HOLDER.get(player)).hasData(((CrownOfDemon)((Object)CoPItems.CROWN_OF_DEMON.get())).getKey());
    }

    public static boolean isPeon(Mob entity) {
        return entity.m_6336_() == MobType.f_21641_ && entity.m_21172_(Attributes.f_22276_) <= CrownOfDemon.getThreshold();
    }

    public static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.hell.crownOfDemonRealityIndex.get();
    }

    public static double getThreshold() {
        return ((Integer)CoPConfig.COMMON.hell.crownOfDemonBaseHealthThreshold.get()).intValue();
    }

    public static double getRange() {
        return ((Integer)CoPConfig.COMMON.hell.crownOfDemonRange.get()).intValue();
    }

    public CrownOfDemon(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= CrownOfDemon.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(CrownOfDemon.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Hell.CROWN.get(new Object[0]).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)CrownOfDemon.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        private static final int REFRESH = 100;
        private final Set<Mob> peon = new LinkedHashSet<Mob>();
        private int active = 0;

        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                return;
            }
            if (player.f_19797_ % 20 != 0) {
                return;
            }
            if (this.active == 0) {
                return;
            }
            if (this.active > 0) {
                --this.active;
                if (this.active == 0) {
                    this.peon.clear();
                    return;
                }
                this.refresh(player);
            }
        }

        private void refresh(Player player) {
            if (this.active > 0) {
                this.active = 100;
                if (player.f_19797_ % 20 != 0) {
                    return;
                }
            }
            this.active = 100;
            this.peon.removeIf(e -> !e.m_6084_());
            AABB aabb = player.m_20191_().m_82400_(CrownOfDemon.getRange());
            for (Mob e2 : player.m_9236_().m_142425_(EntityTypeTest.m_156916_(Mob.class), aabb, CrownOfDemon::isPeon)) {
                if (this.peon.contains(e2)) continue;
                this.peon.add(e2);
            }
        }

        @Override
        public void onPlayerAttackTarget(Player player, AttackCache cache) {
            this.refresh(player);
            for (Mob e : this.peon) {
                if (e.m_5448_() != null) continue;
                e.m_6703_(cache.getAttackTarget());
            }
        }
    }
}

