/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.elemental;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WindThrust
extends ITokenProviderItem<Data> {
    private static final AttrAdder SPEED = AttrAdder.of("wind_thrust", () -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, WindThrust::getSpeed);
    private static final AttrAdder DAMAGE = AttrAdder.of("wind_thrust", () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE, WindThrust::getDamage);

    public static boolean check(Player player) {
        return ((ConditionalData)ConditionalData.HOLDER.get(player)).hasData(((WindThrust)((Object)CoPItems.WIND_THRUST.get())).getKey());
    }

    private static double getSpeed() {
        return (Double)CoPConfig.COMMON.elemental.windThrustSpeed.get();
    }

    private static double getDamage() {
        return (Double)CoPConfig.COMMON.elemental.windThrustDamage.get();
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.elemental.windThrustRealityIndex.get();
    }

    public WindThrust(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= WindThrust.getIndexReq();
        list.add((Component)CoPLangData.Elemental.WIND_1.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(WindThrust.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Elemental.WIND_2.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)SPEED.getTooltip()).m_130940_(pass ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)DAMAGE.getTooltip()).m_130940_(pass ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)WindThrust.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken {
        @Override
        protected void removeImpl(Player player) {
            SPEED.removeImpl(player);
            DAMAGE.removeImpl(player);
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                if (player.m_20142_()) {
                    ClientSpellText.onClientAutoAttack(player);
                }
                return;
            }
            if (player.m_20142_()) {
                SPEED.tickImpl(player);
                DAMAGE.tickImpl(player);
            } else {
                SPEED.removeImpl(player);
                DAMAGE.removeImpl(player);
            }
        }
    }
}

