/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.elemental;

import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WavingSpell
extends ITokenProviderItem<Data> {
    private static final AttrAdder MAGIC = AttrAdder.of("waving_spell", () -> ((RegistryEntry)L2DamageTracker.MAGIC_FACTOR).get(), AttributeModifier.Operation.ADDITION, WavingSpell::getStat);

    private static double getStat() {
        return (Double)CoPConfig.COMMON.elemental.wavingSpellBonus.get();
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.elemental.wavingSpellRealityIndex.get();
    }

    public WavingSpell(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= WavingSpell.getIndexReq();
        list.add((Component)CoPLangData.Elemental.WAVING.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(WavingSpell.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)MAGIC.getTooltip()).m_130940_(pass ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)WavingSpell.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken {
        @Override
        protected void removeImpl(Player player) {
            MAGIC.removeImpl(player);
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                return;
            }
            if (player.m_20071_()) {
                MAGIC.tickImpl(player);
            } else {
                MAGIC.removeImpl(player);
            }
        }
    }
}

