/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.angle;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.sets.angle.AngelicPunishment;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AngelicDescent
extends ITokenProviderItem<Data> {
    private static final AttrAdder ATTACK = AttrAdder.of("angelic_descent", () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE, AngelicDescent::getStat);

    private static double getStat() {
        return (Double)CoPConfig.COMMON.angelic.angelicDescentMeleeBonus.get();
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.angelic.angelicDescentRealityIndex.get();
    }

    private static double getBonus() {
        return (Double)CoPConfig.COMMON.angelic.angelicDescentUndeadBonus.get();
    }

    public AngelicDescent(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)CoPLangData.Angelic.CHECK.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        boolean pass = ClientSpellText.getReality(level) >= AngelicDescent.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(AngelicDescent.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Angelic.DESCENT.get(Math.round(AngelicDescent.getBonus() * 100.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)ATTACK.getTooltip()).m_130940_(pass ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)AngelicDescent.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        public void onPlayerHurtTarget(Player player, AttackCache cache) {
            float bonus = 1.0f + (float)AngelicDescent.getBonus();
            if (cache.getAttackTarget().m_6336_() == MobType.f_21641_ && this.check(player)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)bonus));
            }
        }

        @Override
        protected void removeImpl(Player player) {
            ATTACK.removeImpl(player);
        }

        @Override
        protected void tickImpl(Player player) {
            if (player.m_9236_().m_5776_()) {
                return;
            }
            if (this.check(player)) {
                ATTACK.tickImpl(player);
            } else {
                ATTACK.removeImpl(player);
            }
        }

        private boolean check(Player player) {
            return AngelicPunishment.check(player, AngelicDescent.getIndexReq());
        }
    }
}

