/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.abyss;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPEffects;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.curios.L2Totem;
import dev.xkmc.l2damagetracker.contents.curios.TotemUseToClient;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.Nullable;

public class AbyssalWill
extends ITokenProviderItem<Data>
implements L2Totem {
    public static int getDepth(Player player) {
        return ((ConditionalData)ConditionalData.HOLDER.get(player)).hasData(((AbyssalWill)((Object)CoPItems.ABYSSAL_WILL.get())).getKey()) ? (Integer)CoPConfig.COMMON.abyssal.abyssalWillDepthStep.get() : (Integer)CoPConfig.COMMON.abyssal.abyssalDepthStep.get();
    }

    public static int getStep(Player player) {
        int depth = AbyssalWill.getDepth(player);
        double y = player.m_20182_().f_82480_;
        return y > 0.0 ? 0 : (int)(-Math.floor(y / (double)depth));
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.abyssal.abyssalWillRealityIndex.get();
    }

    private static int getCoolDown() {
        return (Integer)CoPConfig.COMMON.abyssal.abyssalWillCoolDown.get();
    }

    private static int getDuration() {
        return (Integer)CoPConfig.COMMON.abyssal.abyssalWillDuration.get();
    }

    private static MobEffectInstance eff() {
        return new MobEffectInstance((MobEffect)CoPEffects.ABYSSAL_PROTECTION.get(), AbyssalWill.getDuration());
    }

    public AbyssalWill(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= AbyssalWill.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(AbyssalWill.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Abyssal.WILL.get(new Object[0])).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)CoPLangData.Abyssal.WILL_TOTEM.get(Math.round((double)AbyssalWill.getDuration() / 20.0), Math.round((double)AbyssalWill.getCoolDown() / 20.0))).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237113_((String)"-> ").m_7220_((Component)CoPLangData.Abyssal.WILL_RESTRICT.get(new Object[0])).m_130940_(pass ? ChatFormatting.RED : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)AbyssalWill.getIndexReq()) {
            super.tick(player);
        }
    }

    public void trigger(LivingEntity self, ItemStack holded, Consumer<ItemStack> second) {
        L2DamageTracker.PACKET_HANDLER.toTrackingPlayers((SimplePacketBase)new TotemUseToClient((Entity)self, holded), (Entity)self);
        self.m_21153_(1.0f);
        self.m_21219_();
        EffectUtil.addEffect((LivingEntity)self, (MobEffectInstance)AbyssalWill.eff(), (EffectUtil.AddReason)EffectUtil.AddReason.SELF, (Entity)self);
        if (self instanceof Player) {
            Player player = (Player)self;
            player.m_36335_().m_41524_((Item)this, AbyssalWill.getCoolDown());
        }
    }

    public boolean allow(LivingEntity self, DamageSource pDamageSource) {
        if (!(self instanceof Player)) {
            return false;
        }
        Player player = (Player)self;
        if (player.m_20186_() > 0.0 && !pDamageSource.m_269533_(DamageTypeTags.f_268413_)) {
            return false;
        }
        return !player.m_36335_().m_41519_((Item)this);
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
        }

        @Override
        public void onPlayerAttacked(Player player, AttackCache cache) {
            LivingAttackEvent event = cache.getLivingAttackEvent();
            assert (event != null);
            if (!player.m_21023_((MobEffect)CoPEffects.ABYSSAL_PROTECTION.get())) {
                return;
            }
            if (event.getSource().m_269533_(DamageTypeTags.f_268413_)) {
                event.setCanceled(true);
            }
        }
    }
}

