/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.abyss;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.sets.abyss.AbyssalWill;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AbyssalShell
extends ITokenProviderItem<Data> {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.abyssal.abyssalShellRealityIndex.get();
    }

    private static double getBonus() {
        return (Double)CoPConfig.COMMON.abyssal.abyssalShellBonus.get();
    }

    private static AttrAdder getArmor(Player player) {
        return AttrAdder.of("abyssal_shell", () -> Attributes.f_22284_, AttributeModifier.Operation.MULTIPLY_BASE, () -> (double)AbyssalWill.getStep(player) * AbyssalShell.getBonus());
    }

    private static AttrAdder getTough(Player player) {
        return AttrAdder.of("abyssal_shell", () -> Attributes.f_22285_, AttributeModifier.Operation.MULTIPLY_BASE, () -> (double)AbyssalWill.getStep(player) * AbyssalShell.getBonus());
    }

    public AbyssalShell(Item.Properties properties) {
        super(properties, Data::new);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= AbyssalShell.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(AbyssalShell.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Abyssal.SHELL.get(ClientSpellText.getDepth(level), Math.round(AbyssalShell.getBonus() * 100.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)AbyssalShell.getIndexReq()) {
            super.tick(player);
        }
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken {
        @Override
        protected void removeImpl(Player player) {
            AbyssalShell.getArmor(player).removeImpl(player);
            AbyssalShell.getTough(player).removeImpl(player);
        }

        @Override
        protected void tickImpl(Player player) {
            if (AbyssalWill.getStep(player) <= 0) {
                AbyssalShell.getArmor(player).removeImpl(player);
                AbyssalShell.getTough(player).removeImpl(player);
            } else {
                AbyssalShell.getArmor(player).tickImpl(player);
                AbyssalShell.getTough(player).tickImpl(player);
            }
        }
    }
}

