/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.reality;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.pandora.content.base.IPandoraHolder;
import dev.xkmc.pandora.content.base.PandoraHolder;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class CursePandoraUtil {
    public static ItemStack allCurses(PandoraHolder holder) {
        ItemStack stack = holder.m_7968_();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(CoPItems.CURSE_OF_INERTIA.asStack());
        list.add(CoPItems.CURSE_OF_PROXIMITY.asStack());
        list.add(CoPItems.CURSE_OF_FLESH.asStack());
        list.add(CoPItems.CURSE_OF_METABOLISM.asStack());
        list.add(CoPItems.CURSE_OF_TENSION.asStack());
        list.add(CoPItems.CURSE_OF_PRUDENCE.asStack());
        list.add(CoPItems.CURSE_OF_SPELL.asStack());
        int n = holder.getSlots(stack);
        for (int i = 7; i < n; ++i) {
            list.add(ItemStack.f_41583_);
        }
        IPandoraHolder.setItems((ItemStack)stack, list);
        return stack;
    }

    public static AttrAdder spell(TokenKey<?> key) {
        return AttrAdder.of(key.id(), CoPAttrs.SPELL, AttributeModifier.Operation.ADDITION, 1.0);
    }

    public static AttrAdder reality(TokenKey<?> key) {
        return AttrAdder.of(key.id(), CoPAttrs.REALITY, AttributeModifier.Operation.ADDITION, 1.0);
    }

    public static void remove(AttributeInstance attr, AttributeModifier.Operation op, UUID negId, String negName, Set<UUID> ignore, ValueConsumer negate, ValueConsumer val, boolean posOnly) {
        Set list = attr.m_22104_(op);
        for (AttributeModifier e : list) {
            if (e.m_22209_().equals(negId)) continue;
            val.accept(e.m_22218_());
            if (ignore.contains(e.m_22209_()) || !(posOnly ^ e.m_22218_() > 0.0)) continue;
            negate.accept(e.m_22218_());
        }
        AttributeModifier old = attr.m_22111_(negId);
        double mod = negate.reverse();
        if (old == null || old.m_22218_() != mod) {
            attr.m_22120_(negId);
            attr.m_22118_(new AttributeModifier(negId, negName, mod, op));
        }
        val.accept(mod);
    }

    public static interface ValueConsumer {
        public void accept(double var1);

        public double get();

        public double reverse();
    }

    public static class BonusMult
    extends Mult {
        private final double factor;

        public BonusMult(double factor) {
            this.factor = factor;
        }

        @Override
        public double reverse() {
            return this.factor / this.val - 1.0;
        }
    }

    public static class Mult
    implements ValueConsumer {
        protected double val = 1.0;

        @Override
        public void accept(double v) {
            this.val *= 1.0 + v;
        }

        @Override
        public double get() {
            return this.val;
        }

        @Override
        public double reverse() {
            return 1.0 / this.val - 1.0;
        }
    }

    public static class Add
    implements ValueConsumer {
        private double val = 0.0;

        @Override
        public void accept(double v) {
            this.val += v;
        }

        @Override
        public double get() {
            return this.val;
        }

        @Override
        public double reverse() {
            return -this.val;
        }
    }
}

