/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.reality;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.ISlotAdderItem;
import dev.xkmc.curseofpandora.content.complex.ISubToken;
import dev.xkmc.curseofpandora.content.complex.ListTickingToken;
import dev.xkmc.curseofpandora.content.reality.AttributeLimiter;
import dev.xkmc.curseofpandora.content.reality.CursePandoraUtil;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CurseOfMetabolismItem
extends ISlotAdderItem<Ticker> {
    private static final TokenKey<Ticker> KEY = new TokenKey("curseofpandora", "curse_of_metabolism");
    private static final AttrAdder R = CursePandoraUtil.reality(KEY);
    private static final AttrAdder S = CursePandoraUtil.spell(KEY);

    private static int getThreshold() {
        return (Integer)CoPConfig.COMMON.curse.curseOfMetabolismThreshold.get();
    }

    private static double getFactor() {
        return (Double)CoPConfig.COMMON.curse.curseOfMetabolismFactor.get();
    }

    private static double getBonus() {
        return (Double)CoPConfig.COMMON.curse.curseOfMetabolismBonus.get();
    }

    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.curse.curseOfMetabolismIndexReq.get();
    }

    public CurseOfMetabolismItem(Item.Properties properties) {
        super(properties, Ticker::new, R, S);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        int f = (int)Math.round(CurseOfMetabolismItem.getFactor() * 100.0);
        int b = (int)Math.round(CurseOfMetabolismItem.getBonus() * 100.0);
        int t = CurseOfMetabolismItem.getThreshold();
        boolean pass = ClientSpellText.getReality(level) >= CurseOfMetabolismItem.getIndexReq();
        list.add((Component)CoPLangData.Reality.METABOLISM_2.get(f, t).m_130940_(ChatFormatting.RED));
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(CurseOfMetabolismItem.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Reality.METABOLISM_1.get(f, t).m_130940_(pass ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_GRAY));
        list.add((Component)CoPLangData.Reality.METABOLISM_3.get(b).m_130940_(pass ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_GRAY));
    }

    public record AttrBonus(Supplier<Attribute> attr, String name, UUID id, boolean bonus) implements ISubToken
    {
        public static AttrBonus of(Supplier<Attribute> attr, String name, boolean bonus) {
            return new AttrBonus(attr, name, MathHelper.getUUIDFromString((String)name), bonus);
        }

        @Override
        public void removeImpl(Player player) {
            if (player.m_9236_().f_46443_) {
                return;
            }
            AttributeInstance ins = player.m_21051_(this.attr.get());
            if (ins == null) {
                return;
            }
            ins.m_22120_(this.id);
        }

        @Override
        public void tickImpl(Player player) {
            AttributeModifier old;
            boolean doBonus;
            if (player.m_9236_().f_46443_) {
                return;
            }
            AttributeInstance ins = player.m_21051_(this.attr.get());
            if (ins == null) {
                return;
            }
            double val = (double)(player.m_36324_().m_38702_() - CurseOfMetabolismItem.getThreshold()) * CurseOfMetabolismItem.getFactor();
            boolean bl = doBonus = this.bonus && player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)CurseOfMetabolismItem.getIndexReq();
            if (!doBonus && val > 0.0) {
                return;
            }
            if (!player.m_36324_().m_38721_()) {
                val += CurseOfMetabolismItem.getBonus();
            }
            if ((old = ins.m_22111_(this.id)) != null && old.m_22218_() == val && old.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                return;
            }
            ins.m_22120_(this.id);
            ins.m_22118_(new AttributeModifier(this.id, this.name, val, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    private static class Lim
    extends AttributeLimiter {
        protected Lim() {
            super(Attributes.f_22279_, "metabolism");
        }

        @Override
        public void tickImpl(Player player) {
            if (player.m_36324_().m_38721_()) {
                this.removeImpl(player);
            } else {
                this.doAttributeLimit(player, Set.of(Ticker.SPEED.id()), true);
            }
        }

        @Override
        protected CursePandoraUtil.ValueConsumer curseMult(double finVal, CursePandoraUtil.Mult valMult) {
            return new CursePandoraUtil.BonusMult(1.0);
        }
    }

    @SerialClass
    public static class Ticker
    extends ListTickingToken {
        private static final AttrBonus ATK = AttrBonus.of(() -> Attributes.f_22281_, "curse_of_metabolism_attack", true);
        private static final AttrBonus SPEED = AttrBonus.of(() -> Attributes.f_22279_, "curse_of_metabolism_speed", true);

        public Ticker() {
            super(List.of(ATK, SPEED, new Lim(), R, S));
        }
    }
}

