/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.curseofpandora.content.entity.WindBladeEntity;
import dev.xkmc.curseofpandora.content.entity.WindBladeWeapon;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class WindBladeEntityRenderer
extends EntityRenderer<WindBladeEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("curseofpandora", "textures/entity/wind_blade.png");

    public WindBladeEntityRenderer(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(WindBladeEntity entity, float yRot, float partial, PoseStack matrix, MultiBufferSource buffer, int light) {
        WindBladeWeapon weapon;
        Item item = entity.getStack().m_41720_();
        if (item instanceof WindBladeWeapon && (weapon = (WindBladeWeapon)item).glow()) {
            light = 0xF000F0;
        }
        matrix.m_85836_();
        matrix.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
        matrix.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partial, (float)entity.f_19859_, (float)entity.m_146908_()) - 90.0f));
        matrix.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partial, (float)entity.f_19860_, (float)entity.m_146909_())));
        matrix.m_252781_(Axis.f_252529_.m_252977_(entity.getZRot()));
        matrix.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        matrix.m_85841_(0.05625f, 0.05625f, 0.05625f);
        VertexConsumer ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose entry = matrix.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        this.rect(matrix4f, matrix3f, ivertexbuilder, 0.0f, 8.0f, -1, light);
        this.rect(matrix4f, matrix3f, ivertexbuilder, 0.0f, 8.0f, 1, light);
        matrix.m_85849_();
        super.m_7392_((Entity)entity, yRot, partial, matrix, buffer, light);
    }

    private void rect(Matrix4f m4f, Matrix3f m3f, VertexConsumer builder, float x, float r, int n, int light) {
        this.vertex(m4f, m3f, builder, r, -r, x, 0.0f, 0.0f, n, 0, 0, light);
        this.vertex(m4f, m3f, builder, r, r, x, 1.0f, 0.0f, n, 0, 0, light);
        this.vertex(m4f, m3f, builder, -r, r, x, 1.0f, 1.0f, n, 0, 0, light);
        this.vertex(m4f, m3f, builder, -r, -r, x, 0.0f, 1.0f, n, 0, 0, light);
    }

    private void vertex(Matrix4f m4f, Matrix3f m3f, VertexConsumer builder, float x, float y, float z, float u, float v, int nx, int nz, int ny, int light) {
        builder.m_252986_(m4f, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(m3f, (float)nx, (float)ny, (float)nz).m_5752_();
    }

    public ResourceLocation getTextureLocation(WindBladeEntity entity) {
        Item item = entity.getStack().m_41720_();
        if (item instanceof WindBladeWeapon) {
            WindBladeWeapon weapon = (WindBladeWeapon)item;
            return weapon.bladeTexture();
        }
        return TEXTURE;
    }
}

