/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.integration.jei;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.block.entity.CrabTrapBlockEntity;
import alabaster.crabbersdelight.common.registry.ModItems;
import alabaster.crabbersdelight.integration.jei.CrabTrapWrapper;
import alabaster.crabbersdelight.integration.jei.JEIPlugin;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CrabTrapCategory
implements IRecipeCategory<CrabTrapWrapper> {
    private static final ResourceLocation CRAB_TRAP_LOCATION = CrabbersDelight.modPrefix("textures/gui/jei_crab_trap.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title = Component.m_237115_((String)("crabbersdelight.jei." + this.getUid().m_135815_()));

    public CrabTrapCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(CRAB_TRAP_LOCATION, 0, 0, 162, 51);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.CRAB_TRAP.get()));
    }

    public RecipeType<CrabTrapWrapper> getRecipeType() {
        return JEIPlugin.CRAB_TRAP_RECIPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrabTrapWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 74, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 34).addItemStacks(Arrays.stream(recipe.getOutput().m_43908_()).toList());
    }

    public List<Component> getTooltipStrings(CrabTrapWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (CrabTrapCategory.iconPosition(mouseX, mouseY)) {
            if ((Integer)CrabTrapBlockEntity.getMinMax().getSecond() > (Integer)CrabTrapBlockEntity.getMinMax().getFirst()) {
                return ImmutableList.of((Object)Component.m_237113_((String)("Items are caught every " + CrabTrapBlockEntity.getMinMax().getFirst() + "-" + CrabTrapBlockEntity.getMinMax().getSecond() + " ticks")));
            }
            return ImmutableList.of((Object)Component.m_237113_((String)"Error in Config: Min value must be below Max value").m_130940_(ChatFormatting.RED));
        }
        return Collections.emptyList();
    }

    private static boolean iconPosition(double mouseX, double mouseY) {
        int iconPosX = 77;
        int iconPosY = 19;
        int iconHeight = 12;
        int iconWidth = 10;
        return (double)iconPosX <= mouseX && mouseX < (double)(iconPosX + iconWidth) && (double)iconPosY <= mouseY && mouseY < (double)(iconPosY + iconHeight);
    }
}

