/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity;

import alabaster.crabbersdelight.common.registry.ModEntities;
import alabaster.crabbersdelight.common.registry.ModItems;
import alabaster.crabbersdelight.common.tags.CDModTags;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CrabEntity
extends Animal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<Integer> VARIANT_ID;
    private static EntityDataAccessor<Boolean> FROM_BUCKET;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private Ingredient temptationItems;

    public CrabEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public Color getCrabColor() {
        return Color.BY_ID[(Integer)this.f_19804_.m_135370_(VARIANT_ID)];
    }

    public void setCrabColor(Color color) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)color.getId());
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(VARIANT_ID)));
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)color.m_41060_());
    }

    public static boolean canSpawn(EntityType<CrabEntity> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return Animal.m_218104_(entityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_ID, (Object)Color.BLUE.getId());
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getCrabColor().getId());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 0.75, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Nullable
    public CrabEntity getBreedOffspring(ServerLevel level, AgeableMob mob) {
        CrabEntity crab = (CrabEntity)((EntityType)ModEntities.CRAB.get()).m_20615_((Level)level);
        if (crab != null) {
            crab.setColor(this.getOffspringColor(this, (CrabEntity)mob));
        }
        return crab;
    }

    private DyeColor getOffspringColor(Animal crab1, Animal crab2) {
        DyeColor dyecolor = ((CrabEntity)crab1).getColor();
        DyeColor dyecolor1 = ((CrabEntity)crab2).getColor();
        CraftingContainer craftingcontainer = CrabEntity.makeContainer(dyecolor, dyecolor1);
        return this.m_9236_().m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingcontainer, this.m_9236_()).map(p_289444_ -> p_289444_.m_5874_((Container)craftingcontainer, this.m_9236_().m_9598_())).map(ItemStack::m_41720_).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::m_41089_).orElseGet(() -> this.m_9236_().f_46441_.m_188499_() ? dyecolor : dyecolor1);
    }

    private static CraftingContainer makeContainer(DyeColor color1, DyeColor color2) {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player player, int item) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player player) {
                return false;
            }
        }, 2, 1);
        craftingcontainer.m_6836_(0, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)color1)));
        craftingcontainer.m_6836_(1, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)color2)));
        return craftingcontainer;
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.m_204132_(CDModTags.CRAB_TEMPT_ITEM);
        }
        return this.temptationItems;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenLoop("animation.crab.walk"));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenLoop("animation.crab.idle"));
        return PlayState.CONTINUE;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    @Nonnull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_ID, (Object)variant);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)true);
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    public void m_6872_(@Nonnull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Age", this.m_146764_());
        tag.m_128405_("Variant", this.getCrabColor().getId());
    }

    public void m_142278_(@Nonnull CompoundTag tag) {
        int i;
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
        if ((i = tag.m_128451_("Variant")) >= 0 && i < Color.BY_ID.length) {
            this.setCrabColor(Color.BY_ID[i]);
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ModItems.CRAB_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        DyeItem dyeItem;
        DyeColor dyeColor;
        Optional result = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this);
        if (result.isPresent()) {
            return (InteractionResult)result.get();
        }
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof DyeItem && (dyeColor = (dyeItem = (DyeItem)item).m_41089_()) != this.getColor()) {
            this.setColor(dyeColor);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    static {
        FROM_BUCKET = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        VARIANT_ID = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FROM_BUCKET = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static enum Color {
        WHITE(0, "white", true),
        ORANGE(1, "orange", true),
        MAGENTA(2, "magenta", true),
        LIGHT_BLUE(3, "light_blue", true),
        YELLOW(4, "yellow", true),
        LIME(5, "lime", true),
        PINK(6, "pink", true),
        GRAY(7, "gray", true),
        LIGHT_GRAY(8, "light_gray", true),
        CYAN(9, "cyan", true),
        PURPLE(10, "purple", true),
        BLUE(11, "blue", true),
        BROWN(12, "brown", true),
        GREEN(13, "green", true),
        RED(14, "red", true),
        BLACK(15, "black", true);

        public static final Color[] BY_ID;
        private final int id;
        private final String name;

        private Color(int j, String name, boolean bool) {
            this.id = j;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Color getTypeById(int id) {
            for (Color type : Color.values()) {
                if (type.id != id) continue;
                return type;
            }
            return BLUE;
        }

        static {
            BY_ID = (Color[])Arrays.stream(Color.values()).sorted(Comparator.comparingInt(Color::getId)).toArray(Color[]::new);
        }
    }
}

