/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rtdd;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.rtdd.init.RtddModBlockEntities;
import net.mcreator.rtdd.init.RtddModBlocks;
import net.mcreator.rtdd.init.RtddModFeatures;
import net.mcreator.rtdd.init.RtddModFluidTypes;
import net.mcreator.rtdd.init.RtddModFluids;
import net.mcreator.rtdd.init.RtddModItems;
import net.mcreator.rtdd.init.RtddModMenus;
import net.mcreator.rtdd.init.RtddModMobEffects;
import net.mcreator.rtdd.init.RtddModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rtdd")
public class RtddMod {
    public static final Logger LOGGER = LogManager.getLogger(RtddMod.class);
    public static final String MODID = "rtdd";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("rtdd", "rtdd"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public RtddMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RtddModBlocks.REGISTRY.register(bus);
        RtddModBlockEntities.REGISTRY.register(bus);
        RtddModItems.REGISTRY.register(bus);
        RtddModTabs.REGISTRY.register(bus);
        RtddModFeatures.REGISTRY.register(bus);
        RtddModMobEffects.REGISTRY.register(bus);
        RtddModMenus.REGISTRY.register(bus);
        RtddModFluids.REGISTRY.register(bus);
        RtddModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

