/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.predicate.ExtendedEntityFlagsPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class ExtendedEntityFlagsPredicateTest {
    private static final BlockPos TEST_POS = new BlockPos(0, 0, 0);

    @GameTest(m_177046_="empty_test_structure")
    public void isMonsterTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isMonster(false).build();
            GameTestUtils.assertTrue(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isMonster(true).build();
            GameTestUtils.assertFalse(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void isCreatureTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isCreature(false).build();
            GameTestUtils.assertFalse(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isCreature(true).build();
            GameTestUtils.assertTrue(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void isUndeadTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20501_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isUndeadMob(false).build();
            GameTestUtils.assertFalse(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isUndeadMob(true).build();
            GameTestUtils.assertTrue(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void isArthropodTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20479_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isArthropodMob(false).build();
            GameTestUtils.assertFalse(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isArthropodMob(true).build();
            GameTestUtils.assertTrue(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void isIllegarTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20513_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isIllegarMob(false).build();
            GameTestUtils.assertFalse(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isIllegarMob(true).build();
            GameTestUtils.assertTrue(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void isWaterMobTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20490_, helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> {
            ExtendedEntityFlagsPredicate fFlag = new ExtendedEntityFlagsPredicate.Builder().isWaterMob(false).build();
            GameTestUtils.assertFalse(helper, fFlag.m_33696_((Entity)entity));
            ExtendedEntityFlagsPredicate tFlag = new ExtendedEntityFlagsPredicate.Builder().isWaterMob(true).build();
            GameTestUtils.assertTrue(helper, tFlag.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void onGroundTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        ExtendedEntityFlagsPredicate flags = new ExtendedEntityFlagsPredicate.Builder().isOnGround(true).build();
        helper.m_177279_(() -> {
            entity.m_6853_(true);
            GameTestUtils.assertTrue(helper, flags.m_33696_((Entity)entity));
            entity.m_6853_(false);
            GameTestUtils.assertFalse(helper, flags.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void inWaterTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        ExtendedEntityFlagsPredicate flags = new ExtendedEntityFlagsPredicate.Builder().isInWater(true).build();
        helper.m_177279_(() -> {
            entity.f_19798_ = false;
            GameTestUtils.assertFalse(helper, flags.m_33696_((Entity)entity));
            entity.f_19798_ = true;
            GameTestUtils.assertTrue(helper, flags.m_33696_((Entity)entity));
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void inUnderWaterTest(GameTestHelper helper) {
        Object entity = GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        ExtendedEntityFlagsPredicate flags = new ExtendedEntityFlagsPredicate.Builder().isUnderWater(true).build();
        helper.m_177279_(() -> {
            entity.f_19798_ = false;
            entity.f_19800_ = false;
            GameTestUtils.assertFalse(helper, flags.m_33696_((Entity)entity));
            entity.f_19798_ = true;
            entity.f_19800_ = true;
            GameTestUtils.assertTrue(helper, flags.m_33696_((Entity)entity));
        });
    }
}

