/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.items;

import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.redstone.IWireConnect;
import com.Da_Technomancer.essentials.api.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.items.ESItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class CircuitWrench
extends Item {
    public static final ArrayList<IWireConnect> MODES = new ArrayList(39);
    public static final ArrayList<ResourceLocation> ICONS = new ArrayList(39);
    public static final String NBT_KEY = "essentials:mode";
    private static final TagKey<Item> COMPONENT_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("essentials", "circuit_components"));
    private static final Style style;

    protected CircuitWrench() {
        super(ESItems.baseItemProperties().m_41487_(1));
        String name = "circuit_wrench";
        ESItems.queueForRegister(name, this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6047_()) {
            if (!worldIn.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)UIProvider.INSTANCE);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockState toPlace = MODES.get(context.m_43722_().m_41784_().m_128451_(NBT_KEY) % MODES.size()).wireAsBlock().m_49966_();
        if (state.m_60734_() instanceof AbstractTile) {
            if (!context.m_43723_().m_6144_()) {
                AbstractTile placeTile;
                AbstractTile worldTile = (AbstractTile)state.m_60734_();
                if (worldTile == (placeTile = (AbstractTile)toPlace.m_60734_())) {
                    return InteractionResult.SUCCESS;
                }
                boolean allowed = false;
                if (context.m_43723_().m_7500_()) {
                    allowed = true;
                } else if (placeTile.usesQuartz()) {
                    if (worldTile.usesQuartz()) {
                        allowed = true;
                    } else {
                        NonNullList playerInv = context.m_43723_().m_150109_().f_35974_;
                        for (ItemStack stack : playerInv) {
                            if (!stack.m_204117_(COMPONENT_TAG)) continue;
                            if (!context.m_43725_().f_46443_) {
                                stack.m_41774_(1);
                            }
                            allowed = true;
                            break;
                        }
                    }
                } else {
                    ItemStack given;
                    allowed = true;
                    if (worldTile.usesQuartz() && !(given = new ItemStack((ItemLike)ForgeRegistries.ITEMS.tags().getTag(COMPONENT_TAG).getRandomElement(context.m_43725_().f_46441_).orElse(Items.f_42692_), 1)).m_41619_()) {
                        context.m_43723_().m_36356_(given);
                    }
                }
                if (allowed) {
                    if (toPlace.m_61138_((Property)ESProperties.HORIZ_FACING)) {
                        toPlace = state.m_61138_((Property)ESProperties.HORIZ_FACING) ? (BlockState)toPlace.m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING))) : (BlockState)toPlace.m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)context.m_43723_().m_6374_());
                    }
                    context.m_43725_().m_46597_(context.m_8083_(), toPlace);
                    return InteractionResult.SUCCESS;
                }
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"tt.essentials.circuit_wrench.quartz"), true);
                return InteractionResult.FAIL;
            }
            if (state.m_61138_((Property)ESProperties.HORIZ_FACING)) {
                context.m_43725_().m_46597_(context.m_8083_(), (BlockState)state.m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING)).m_122427_()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int mode = stack.m_41784_().m_128451_(NBT_KEY) % MODES.size();
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.circuit_wrench_setting").m_6270_(style).m_7220_((Component)Component.m_237115_((String)MODES.get(mode).wireAsBlock().m_7705_())));
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.circuit_wrench_info"));
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.circuit_wrench_change_mode"));
    }

    static {
        RedstoneUtil.registerCircuit(ESBlocks.wireCircuit, new ResourceLocation("essentials", "textures/gui/circuit/wire.png"));
        RedstoneUtil.registerCircuit(ESBlocks.wireJunctionCircuit, new ResourceLocation("essentials", "textures/gui/circuit/wire_junction.png"));
        RedstoneUtil.registerCircuit(ESBlocks.interfaceCircuit, new ResourceLocation("essentials", "textures/gui/circuit/interface.png"));
        RedstoneUtil.registerCircuit(ESBlocks.readerCircuit, new ResourceLocation("essentials", "textures/gui/circuit/reader.png"));
        RedstoneUtil.registerCircuit(ESBlocks.consCircuit, new ResourceLocation("essentials", "textures/gui/circuit/constant.png"));
        RedstoneUtil.registerCircuit(ESBlocks.notCircuit, new ResourceLocation("essentials", "textures/gui/circuit/not.png"));
        RedstoneUtil.registerCircuit(ESBlocks.andCircuit, new ResourceLocation("essentials", "textures/gui/circuit/and.png"));
        RedstoneUtil.registerCircuit(ESBlocks.orCircuit, new ResourceLocation("essentials", "textures/gui/circuit/or.png"));
        RedstoneUtil.registerCircuit(ESBlocks.xorCircuit, new ResourceLocation("essentials", "textures/gui/circuit/xor.png"));
        RedstoneUtil.registerCircuit(ESBlocks.sumCircuit, new ResourceLocation("essentials", "textures/gui/circuit/sum.png"));
        RedstoneUtil.registerCircuit(ESBlocks.difCircuit, new ResourceLocation("essentials", "textures/gui/circuit/dif.png"));
        RedstoneUtil.registerCircuit(ESBlocks.prodCircuit, new ResourceLocation("essentials", "textures/gui/circuit/prod.png"));
        RedstoneUtil.registerCircuit(ESBlocks.quotCircuit, new ResourceLocation("essentials", "textures/gui/circuit/quot.png"));
        RedstoneUtil.registerCircuit(ESBlocks.invCircuit, new ResourceLocation("essentials", "textures/gui/circuit/inv.png"));
        RedstoneUtil.registerCircuit(ESBlocks.moduloCircuit, new ResourceLocation("essentials", "textures/gui/circuit/modulo.png"));
        RedstoneUtil.registerCircuit(ESBlocks.powCircuit, new ResourceLocation("essentials", "textures/gui/circuit/pow.png"));
        RedstoneUtil.registerCircuit(ESBlocks.logCircuit, new ResourceLocation("essentials", "textures/gui/circuit/log.png"));
        RedstoneUtil.registerCircuit(ESBlocks.sinCircuit, new ResourceLocation("essentials", "textures/gui/circuit/sin.png"));
        RedstoneUtil.registerCircuit(ESBlocks.cosCircuit, new ResourceLocation("essentials", "textures/gui/circuit/cos.png"));
        RedstoneUtil.registerCircuit(ESBlocks.tanCircuit, new ResourceLocation("essentials", "textures/gui/circuit/tan.png"));
        RedstoneUtil.registerCircuit(ESBlocks.asinCircuit, new ResourceLocation("essentials", "textures/gui/circuit/asin.png"));
        RedstoneUtil.registerCircuit(ESBlocks.acosCircuit, new ResourceLocation("essentials", "textures/gui/circuit/acos.png"));
        RedstoneUtil.registerCircuit(ESBlocks.atanCircuit, new ResourceLocation("essentials", "textures/gui/circuit/atan.png"));
        RedstoneUtil.registerCircuit(ESBlocks.maxCircuit, new ResourceLocation("essentials", "textures/gui/circuit/max.png"));
        RedstoneUtil.registerCircuit(ESBlocks.minCircuit, new ResourceLocation("essentials", "textures/gui/circuit/min.png"));
        RedstoneUtil.registerCircuit(ESBlocks.roundCircuit, new ResourceLocation("essentials", "textures/gui/circuit/round.png"));
        RedstoneUtil.registerCircuit(ESBlocks.floorCircuit, new ResourceLocation("essentials", "textures/gui/circuit/floor.png"));
        RedstoneUtil.registerCircuit(ESBlocks.ceilCircuit, new ResourceLocation("essentials", "textures/gui/circuit/ceil.png"));
        RedstoneUtil.registerCircuit(ESBlocks.equalsCircuit, new ResourceLocation("essentials", "textures/gui/circuit/equals.png"));
        RedstoneUtil.registerCircuit(ESBlocks.lessCircuit, new ResourceLocation("essentials", "textures/gui/circuit/less.png"));
        RedstoneUtil.registerCircuit(ESBlocks.moreCircuit, new ResourceLocation("essentials", "textures/gui/circuit/more.png"));
        RedstoneUtil.registerCircuit(ESBlocks.absCircuit, new ResourceLocation("essentials", "textures/gui/circuit/abs.png"));
        RedstoneUtil.registerCircuit(ESBlocks.timerCircuit, new ResourceLocation("essentials", "textures/gui/circuit/timer.png"));
        RedstoneUtil.registerCircuit(ESBlocks.delayCircuit, new ResourceLocation("essentials", "textures/gui/circuit/delay.png"));
        RedstoneUtil.registerCircuit(ESBlocks.pulseCircuitRising, new ResourceLocation("essentials", "textures/gui/circuit/pulse_rising.png"));
        RedstoneUtil.registerCircuit(ESBlocks.pulseCircuitFalling, new ResourceLocation("essentials", "textures/gui/circuit/pulse_falling.png"));
        RedstoneUtil.registerCircuit(ESBlocks.pulseCircuitDual, new ResourceLocation("essentials", "textures/gui/circuit/pulse_dual.png"));
        RedstoneUtil.registerCircuit(ESBlocks.signCircuit, new ResourceLocation("essentials", "textures/gui/circuit/sign.png"));
        RedstoneUtil.registerCircuit(ESBlocks.dCounterCircuit, new ResourceLocation("essentials", "textures/gui/circuit/d_counter.png"));
        style = Style.f_131099_.m_131157_(ChatFormatting.DARK_RED);
    }

    private static class UIProvider
    implements MenuProvider {
        private static final UIProvider INSTANCE = new UIProvider();

        private UIProvider() {
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int menuId, Inventory playerInv, Player player) {
            return new CircuitWrenchContainer(menuId, playerInv, null);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.circuit_wrench");
        }
    }
}

