/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.integration;

import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.CircuitTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.InterfaceCircuitTileEntity;
import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.util.LazyOptional;

public class ComputerCraftIntegration {
    public static void init() {
        ForgeComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new CircuitPeripheralProvider());
    }

    private static class CircuitPeripheralProvider
    implements IPeripheralProvider {
        private CircuitPeripheralProvider() {
        }

        @Nonnull
        public LazyOptional<IPeripheral> getPeripheral(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Direction side) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == ESBlocks.interfaceCircuit) {
                Direction circuitFace = (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING);
                CircuitTileEntity.Orient orient = CircuitTileEntity.Orient.getOrient(side, circuitFace);
                if (orient == CircuitTileEntity.Orient.FRONT) {
                    return LazyOptional.of(() -> new CircuitInPeripheral(world, pos));
                }
                if (orient == CircuitTileEntity.Orient.BACK) {
                    return LazyOptional.of(() -> new CircuitOutPeripheral(world, pos));
                }
            }
            return LazyOptional.empty();
        }
    }

    public static class CircuitInPeripheral
    implements IPeripheral {
        private final Level level;
        private final BlockPos pos;
        private InterfaceCircuitTileEntity te;

        public CircuitInPeripheral(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }

        @Nullable
        private InterfaceCircuitTileEntity getTE() {
            BlockEntity newTE;
            if (this.te == null && (newTE = this.level.m_7702_(this.pos)) instanceof InterfaceCircuitTileEntity) {
                this.te = (InterfaceCircuitTileEntity)newTE;
            }
            return this.te;
        }

        @Nonnull
        public String getType() {
            return "circuit_reader";
        }

        public boolean equals(@Nullable IPeripheral other) {
            CircuitInPeripheral cPer;
            return other == this || other instanceof CircuitInPeripheral && (cPer = (CircuitInPeripheral)other).getTE() == this.getTE();
        }

        @Nullable
        public Object getTarget() {
            return this.getTE();
        }

        @LuaFunction
        public final float getCircuitOutput() throws LuaException {
            InterfaceCircuitTileEntity te = this.getTE();
            if (te == null) {
                throw new LuaException("Circuit peripheral does not exist as a block entity");
            }
            return te.getOutput();
        }
    }

    public static class CircuitOutPeripheral
    implements IPeripheral {
        private final Level level;
        private final BlockPos pos;
        private InterfaceCircuitTileEntity te;

        public CircuitOutPeripheral(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos;
        }

        @Nullable
        private InterfaceCircuitTileEntity getTE() {
            BlockEntity newTE;
            if (this.te == null && (newTE = this.level.m_7702_(this.pos)) instanceof InterfaceCircuitTileEntity) {
                this.te = (InterfaceCircuitTileEntity)newTE;
            }
            return this.te;
        }

        @Nonnull
        public String getType() {
            return "circuit_emitter";
        }

        public boolean equals(@Nullable IPeripheral other) {
            CircuitOutPeripheral cPer;
            return other == this || other instanceof CircuitOutPeripheral && (cPer = (CircuitOutPeripheral)other).getTE() == this.getTE();
        }

        @Nullable
        public Object getTarget() {
            return this.getTE();
        }

        public void detach(@Nonnull IComputerAccess computer) {
            InterfaceCircuitTileEntity te = this.getTE();
            if (te != null && te.externalInput != null) {
                te.externalInput = null;
                te.m_6596_();
                te.handleInputChange(TickPriority.HIGH);
            }
        }

        @LuaFunction
        public final void setCircuitOutput(double signal) throws LuaException {
            InterfaceCircuitTileEntity te = this.getTE();
            if (te == null) {
                throw new LuaException("Circuit peripheral does not exist as a block entity");
            }
            te.externalInput = Float.valueOf((float)signal);
            te.m_6596_();
            te.handleInputChange(TickPriority.HIGH);
        }
    }
}

