/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.api.BlockMenuContainer;
import com.Da_Technomancer.essentials.blocks.SlottedChestTileEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ObjectHolder;

public class SlottedChestContainer
extends BlockMenuContainer<SlottedChestTileEntity> {
    @ObjectHolder(registryName="menu", value="essentials:slotted_chest")
    private static MenuType<SlottedChestContainer> TYPE = null;

    public SlottedChestContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        super(TYPE, id, playerInventory, data);
        for (int i = 0; i < ((SlottedChestTileEntity)this.te).lockedInv.length; ++i) {
            ((SlottedChestTileEntity)this.te).lockedInv[i] = data.m_130267_();
        }
    }

    @Override
    protected int[] getInvStart() {
        return new int[]{8, 139};
    }

    @Override
    protected void addSlots() {
        int numRows = ((SlottedChestTileEntity)this.te).lockedInv.length / 9;
        for (int j = 0; j < numRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new SlottedChestStrictSlot((SlottedChestTileEntity)this.te, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
    }

    @Override
    protected int slotCount() {
        return ((SlottedChestTileEntity)this.te).lockedInv.length;
    }

    public ItemStack getFilterInSlot(int slot) {
        return ((SlottedChestTileEntity)this.te).lockedInv[slot];
    }

    protected boolean m_38903_(ItemStack movedStack, int slotIndexStart, int slotIndexEnd, boolean toPlayerInv) {
        if (toPlayerInv) {
            return super.m_38903_(movedStack, slotIndexStart, slotIndexEnd, toPlayerInv);
        }
        boolean flag = false;
        int i = slotIndexStart;
        if (toPlayerInv) {
            i = slotIndexEnd - 1;
        }
        if (movedStack.m_41753_()) {
            while (!movedStack.m_41619_() && !(!toPlayerInv ? i >= slotIndexEnd : i < slotIndexStart)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)movedStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + movedStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), movedStack.m_41741_()))) {
                        movedStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        movedStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (toPlayerInv) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.m_41619_()) {
            i = toPlayerInv ? slotIndexEnd - 1 : slotIndexStart;
            while (!(!toPlayerInv ? i >= slotIndexEnd : i < slotIndexStart)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && ((SlottedChestTileEntity)this.te).m_7013_(i, movedStack)) {
                    if (movedStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(movedStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(movedStack.m_41620_(movedStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (toPlayerInv) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int fromSlot) {
        if (fromSlot < this.slotCount() && !this.m_38853_(fromSlot).m_6657_()) {
            ((SlottedChestTileEntity)this.te).lockedInv[fromSlot] = ItemStack.f_41583_;
            ((SlottedChestTileEntity)this.te).m_6596_();
        }
        return super.m_7648_(playerIn, fromSlot);
    }

    private static class SlottedChestStrictSlot
    extends BlockMenuContainer.StrictSlot {
        private final SlottedChestTileEntity ste;

        public SlottedChestStrictSlot(SlottedChestTileEntity te, int index, int x, int y) {
            super((Container)te, index, x, y);
            this.ste = te;
        }

        @Override
        public boolean m_5857_(ItemStack stack) {
            return this.ste.canPlaceItemUI(this.f_40219_, stack);
        }
    }
}

