/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.api.packets.ConfigureWrenchOnServer;
import com.Da_Technomancer.essentials.api.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.api.redstone.IWireConnect;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.items.CircuitWrench;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class CircuitWrenchScreen
extends AbstractContainerScreen<CircuitWrenchContainer> {
    private static final ResourceLocation SEARCH_BAR_TEXTURE = new ResourceLocation("essentials", "textures/gui/search_bar.png");
    private static final ResourceLocation ROW_TEXTURE = new ResourceLocation("essentials", "textures/gui/row.png");
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("essentials", "textures/gui/circuit/missing.png");
    private static final int ROWS = 8;
    private static final int COLUMNS = 8;
    private EditBox searchBar;
    private final ArrayList<Integer> options = new ArrayList();
    public static final Style CIRCUIT_WRENCH_STYLE = Style.f_131099_.m_131157_(ChatFormatting.DARK_RED);

    public CircuitWrenchScreen(CircuitWrenchContainer cont, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)cont, playerInventory, text);
        this.f_97727_ = 162;
        this.f_97726_ = 144;
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            this.options.add(i);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBar = new EditBox(this.f_96547_, this.f_97735_ + 4, this.f_97736_ + 8, 140, 18, (Component)Component.m_237115_((String)"container.search_bar"));
        this.searchBar.m_94190_(false);
        this.searchBar.m_94202_(-1);
        this.searchBar.m_94205_(-1);
        this.searchBar.m_94182_(false);
        this.searchBar.m_94199_(20);
        this.searchBar.m_94151_(this::filterChanged);
        this.m_7787_((GuiEventListener)this.searchBar);
        this.m_264313_((GuiEventListener)this.searchBar);
    }

    public void m_6574_(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String s = this.searchBar.m_94155_();
        this.m_6575_(p_resize_1_, p_resize_2_, p_resize_3_);
        this.searchBar.m_94144_(s);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.searchBar.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.searchBar.m_94204_() || super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private int getSelectedMode(float xPos, float yPos) {
        int xInd = (int)Math.floor((xPos -= (float)this.f_97735_) / 18.0f);
        int yInd = (int)Math.floor((yPos -= (float)(this.f_97736_ + 18)) / 18.0f);
        int index = xInd + yInd * 8;
        if (xInd < 0 || yInd < 0 || xInd >= 8 || yInd >= 8 || index >= this.options.size() || index < 0) {
            return -1;
        }
        return this.options.get(index);
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrix);
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        int index = this.getSelectedMode(mouseX, mouseY);
        if (index >= 0) {
            ArrayList<MutableComponent> tt = new ArrayList<MutableComponent>();
            tt.add(Component.m_237115_((String)CircuitWrench.MODES.get(index).wireAsBlock().m_7705_()));
            IWireConnect block = CircuitWrench.MODES.get(index);
            block.wireAsBlock().m_5871_(ItemStack.f_41583_, null, tt, (TooltipFlag)TooltipFlag.Default.f_256752_);
            matrix.m_280666_(this.f_96547_, tt, mouseX, mouseY);
        }
        this.searchBar.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    private void filterChanged(String newFilter) {
        this.options.clear();
        for (int i = 0; i < CircuitWrench.MODES.size(); ++i) {
            IWireConnect tile = CircuitWrench.MODES.get(i);
            String name = I18n.m_118938_((String)tile.wireAsBlock().m_7705_(), (Object[])new Object[0]).toLowerCase();
            if (!name.contains(newFilter.toLowerCase().trim())) continue;
            this.options.add(i);
        }
    }

    public boolean m_6375_(double xPos, double yPos, int button) {
        if (button != 0) {
            return super.m_6375_(xPos, yPos, button);
        }
        int index = this.getSelectedMode((int)xPos, (int)yPos);
        if (index < 0) {
            return super.m_6375_(xPos, yPos, button);
        }
        EssentialsPackets.channel.sendToServer((Object)new ConfigureWrenchOnServer(index));
        this.f_96541_.f_91074_.m_6915_();
        this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"tt.essentials.circuit_wrench_setting").m_6270_(CIRCUIT_WRENCH_STYLE).m_7220_((Component)Component.m_237115_((String)CircuitWrench.MODES.get(index).wireAsBlock().m_7705_())), true);
        return true;
    }

    protected void m_7286_(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        int i;
        matrix.m_280163_(SEARCH_BAR_TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, 18, this.f_97726_, 18);
        for (i = 1; i <= 8; ++i) {
            matrix.m_280163_(ROW_TEXTURE, this.f_97735_, this.f_97736_ + i * 18, 0.0f, 0.0f, this.f_97726_, 18, this.f_97726_, 18);
        }
        for (i = 0; i < this.options.size(); ++i) {
            Integer ind = this.options.get(i);
            ResourceLocation sprite = CircuitWrench.ICONS.get(ind);
            if (sprite == null) {
                sprite = MISSING_TEXTURE;
            }
            matrix.m_280163_(sprite, i % 8 * 18 + 1 + this.f_97735_, i / 8 * 18 + 19 + this.f_97736_, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    protected void m_280003_(GuiGraphics matrix, int p_230451_2_, int p_230451_3_) {
    }
}

