/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.blocks.AutoCrafterTileEntity;
import com.Da_Technomancer.essentials.gui.container.AutoCrafterContainer;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class AutoCrafterScreen
extends AbstractContainerScreen<AutoCrafterContainer>
implements RecipeUpdateListener {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("essentials", "textures/gui/auto_crafter.png");
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    private final RecipeBookComponent recipeBook = new RecipeBookComponent();
    private boolean widthTooNarrow;
    private float time = 0.0f;

    public AutoCrafterScreen(AutoCrafterContainer cont, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)cont, playerInventory, text);
        this.f_97727_ = 186;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.recipeBook.m_100309_(this.f_96543_, this.f_96544_, Minecraft.m_91087_(), this.widthTooNarrow, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBook.m_181401_(this.f_96543_, this.f_97726_);
        this.m_7787_((GuiEventListener)this.recipeBook);
        this.m_264313_((GuiEventListener)this.recipeBook);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, p_214076_1_ -> {
            this.recipeBook.m_181404_();
            this.recipeBook.m_100384_();
            this.f_97735_ = this.recipeBook.m_181401_(this.f_96543_, this.f_97726_);
            ((ImageButton)p_214076_1_).m_264152_(this.f_97735_ + 5, this.f_96544_ / 2 - 49);
        }));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.time += partialTicks;
        this.m_280273_(matrix);
        if (this.recipeBook.m_100385_() && this.widthTooNarrow) {
            this.m_7286_(matrix, partialTicks, mouseX, mouseY);
            this.recipeBook.m_88315_(matrix, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBook.m_88315_(matrix, mouseX, mouseY, partialTicks);
            super.m_88315_(matrix, mouseX, mouseY, partialTicks);
            this.recipeBook.m_280128_(matrix, this.f_97735_, this.f_97736_, true, partialTicks);
        }
        this.m_280072_(matrix, mouseX, mouseY);
        this.recipeBook.m_280545_(matrix, this.f_97735_, this.f_97736_, mouseX, mouseY);
        this.m_94725_((GuiEventListener)this.recipeBook);
    }

    protected boolean m_6774_(int p_195359_1_, int p_195359_2_, int p_195359_3_, int p_195359_4_, double p_195359_5_, double p_195359_7_) {
        return (!this.widthTooNarrow || !this.recipeBook.m_100385_()) && super.m_6774_(p_195359_1_, p_195359_2_, p_195359_3_, p_195359_4_, p_195359_5_, p_195359_7_);
    }

    public boolean m_6375_(double x, double y, int p_mouseClicked_5_) {
        if (this.recipeBook.m_6375_(x, y, p_mouseClicked_5_)) {
            return true;
        }
        return this.widthTooNarrow && this.recipeBook.m_100385_() || super.m_6375_(x, y, p_mouseClicked_5_);
    }

    protected boolean m_7467_(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        boolean flag = p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.f_97726_) || p_195361_3_ >= (double)(p_195361_6_ + this.f_97727_);
        return this.recipeBook.m_100297_(p_195361_1_, p_195361_3_, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, p_195361_7_) && flag;
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slotIn, slotId, mouseButton, type);
        this.recipeBook.m_6904_(slotIn);
    }

    public void m_6916_() {
        this.recipeBook.m_100387_();
    }

    public RecipeBookComponent m_5564_() {
        return this.recipeBook;
    }

    public void m_181908_() {
        super.m_181908_();
        this.recipeBook.m_100386_();
    }

    protected ResourceLocation getBackgroundTexture() {
        return GUI_TEXTURE;
    }

    protected void m_7286_(GuiGraphics matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_280218_(this.getBackgroundTexture(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((AutoCrafterContainer)this.f_97732_).te == null) {
            return;
        }
        ItemStack[] inv = new ItemStack[19];
        for (int i = 10; i < inv.length; ++i) {
            inv[i] = ((AutoCrafterContainer)this.f_97732_).m_38853_(i).m_7993_();
        }
        Recipe<CraftingContainer> iRecipe = ((AutoCrafterContainer)this.f_97732_).te.findRecipe(AutoCrafterTileEntity.prepareCraftingInv(inv), (AutoCrafterContainer)this.f_97732_);
        if (iRecipe != null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            if (((AutoCrafterContainer)this.f_97732_).te.recipe != null) {
                boolean shaped = iRecipe instanceof IShapedRecipe;
                int width = 3;
                if (shaped) {
                    width = ((IShapedRecipe)iRecipe).getRecipeWidth();
                }
                NonNullList ingredients = iRecipe.m_7527_();
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack[] matching = ((Ingredient)ingredients.get(i)).m_43908_();
                    if (matching.length == 0) continue;
                    ItemStack s = matching[(int)Math.floor(this.time / 30.0f) % matching.length];
                    matrix.m_280480_(s, 44 + 18 * (i % width) + this.f_97735_, 15 + 18 * (i / width) + this.f_97736_);
                }
            }
            ItemStack output = iRecipe.m_8043_(((AutoCrafterContainer)this.f_97732_).te.m_58904_().m_9598_());
            matrix.m_280480_(output, 106 + this.f_97735_, 33 + this.f_97736_);
            matrix.m_280302_(this.f_96547_, output, this.f_97735_ + 106, this.f_97736_ + 33, null);
        }
    }

    public static List<RecipeBookCategories> getRecipeCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_SEARCH, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_REDSTONE});
    }
}

