/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.api.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.api.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class WireTileEntity
extends BlockEntity {
    public static final BlockEntityType<WireTileEntity> TYPE = ESTileEntity.createType(WireTileEntity::new, new Block[]{ESBlocks.wireCircuit});
    public long lastUpdateTime;
    protected LazyOptional<RedsHandler> redsOptional = LazyOptional.of(this::createRedsHandler);

    protected WireTileEntity(BlockEntityType<? extends WireTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public WireTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    protected RedsHandler createRedsHandler() {
        return new RedsHandler();
    }

    public void m_7651_() {
        super.m_7651_();
        this.redsOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY && (side == null || side.m_122434_() != Direction.Axis.Y)) {
            return this.redsOptional;
        }
        return super.getCapability(cap, side);
    }

    protected class RedsHandler
    implements IRedstoneHandler {
        protected RedsHandler() {
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireTileEntity.this.f_58858_);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                BlockEntity neighbor;
                if (dir == fromSide || (neighbor = WireTileEntity.this.f_58857_.m_7702_(WireTileEntity.this.f_58858_.m_121945_(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeDependents(src, dist, dir.m_122424_(), nominalSide, visited);
                    continue;
                }
                handler.findDependents(src, dist, dir.m_122424_(), nominalSide);
            }
        }

        protected void routeDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide, HashSet<BlockPos> visited) {
            if (!visited.add(WireTileEntity.this.f_58858_) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                BlockEntity neighbor;
                if (dir == fromSide || (neighbor = WireTileEntity.this.f_58857_.m_7702_(WireTileEntity.this.f_58858_.m_121945_(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeDependents(src, dist, dir.m_122424_(), nominalSide, visited);
                    continue;
                }
                handler.findDependents(src, dist, dir.m_122424_(), nominalSide);
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireTileEntity.this.f_58858_);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                BlockEntity neighbor;
                if (dir == toSide || (neighbor = WireTileEntity.this.f_58857_.m_7702_(WireTileEntity.this.f_58858_.m_121945_(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeSrc(dependency, dist, dir.m_122424_(), nominalSide, visited);
                    continue;
                }
                handler.requestSrc(dependency, dist, dir.m_122424_(), nominalSide);
            }
        }

        protected void routeSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide, HashSet<BlockPos> visited) {
            if (!visited.add(WireTileEntity.this.f_58858_) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                BlockEntity neighbor;
                if (dir == toSide || (neighbor = WireTileEntity.this.f_58857_.m_7702_(WireTileEntity.this.f_58858_.m_121945_(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeSrc(dependency, dist, dir.m_122424_(), nominalSide, visited);
                    continue;
                }
                handler.requestSrc(dependency, dist, dir.m_122424_(), nominalSide);
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
        }
    }
}

