/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.api.ITickableTileEntity;
import com.Da_Technomancer.essentials.api.packets.INBTReceiver;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.CircuitTileEntity;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.TimerCircuitContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TimerCircuitTileEntity
extends CircuitTileEntity
implements MenuProvider,
INBTReceiver,
ITickableTileEntity {
    public static final BlockEntityType<TimerCircuitTileEntity> TYPE = ESTileEntity.createType(TimerCircuitTileEntity::new, new Block[]{ESBlocks.timerCircuit});
    private static final int MIN_PERIOD = 1;
    private static final int MIN_DURATION = 0;
    public int settingPeriod = 4;
    public String settingStrPeriod = "4";
    public int settingDuration = 2;
    public String settingStrDuration = "2";
    private long ticksExisted = 0L;

    public TimerCircuitTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    protected AbstractCircuit getOwner() {
        return ESBlocks.timerCircuit;
    }

    public int timerOutput() {
        if (this.ticksExisted / 2L % (long)this.settingPeriod < (long)this.settingDuration) {
            return 1;
        }
        return 0;
    }

    @Override
    public void tick() {
        ++this.ticksExisted;
        int clockTime = (int)(this.ticksExisted / 2L) % this.settingPeriod;
        if (!(this.f_58857_.f_46443_ || this.ticksExisted % 2L != 0L || clockTime != 0 && clockTime != this.settingDuration)) {
            this.recalculateOutput();
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("setting_p", this.settingPeriod);
        nbt.m_128359_("setting_s_p", this.settingStrPeriod);
        nbt.m_128405_("setting_d", this.settingDuration);
        nbt.m_128359_("setting_s_d", this.settingStrDuration);
        nbt.m_128356_("existed", this.ticksExisted);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("setting_p", this.settingPeriod);
        nbt.m_128359_("setting_s_p", this.settingStrPeriod);
        nbt.m_128405_("setting_d", this.settingDuration);
        nbt.m_128359_("setting_s_d", this.settingStrDuration);
        nbt.m_128356_("existed", this.ticksExisted);
        return nbt;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.settingPeriod = nbt.m_128451_("setting_p");
        this.settingStrPeriod = nbt.m_128461_("setting_s_p");
        this.settingDuration = nbt.m_128451_("setting_d");
        this.settingStrDuration = nbt.m_128461_("setting_s_d");
        this.ticksExisted = nbt.m_128454_("existed");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.timer_circuit");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new TimerCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.f_58858_, this.settingStrPeriod, this.settingStrDuration));
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        this.settingPeriod = Math.max(1, Math.round(nbt.m_128457_("value_0")));
        this.settingStrPeriod = nbt.m_128461_("text_0");
        this.settingDuration = Math.max(0, Math.round(nbt.m_128457_("value_1")));
        this.settingStrDuration = nbt.m_128461_("text_1");
        this.m_6596_();
        this.recalculateOutput();
    }
}

