/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.ILinkTE;
import com.Da_Technomancer.essentials.api.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.api.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneTransmitterTileEntity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneReceiverTileEntity
extends BlockEntity
implements ILinkTE {
    private BlockPos src = null;
    public static final BlockEntityType<RedstoneReceiverTileEntity> TYPE = ESTileEntity.createType(RedstoneReceiverTileEntity::new, new Block[]{ESBlocks.redstoneReceiver});
    private LazyOptional<IRedstoneHandler> circOpt = LazyOptional.of(() -> new CircHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> circRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.circOpt);
    private final ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> dependents = new ArrayList(1);

    public RedstoneReceiverTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayer sendingPlayer) {
    }

    @Override
    public boolean canBeginLinking() {
        return false;
    }

    @Override
    public boolean createLinkSource(ILinkTE endpoint, @Nullable Player player) {
        return false;
    }

    @Override
    public void removeLinkSource(BlockPos end) {
    }

    @Override
    public void createLinkEnd(ILinkTE newSrcTE) {
        BlockPos worldSrc;
        BlockEntity srcTE;
        if (this.src != null && (srcTE = this.f_58857_.m_7702_(worldSrc = this.f_58858_.m_121955_((Vec3i)this.src))) instanceof RedstoneTransmitterTileEntity) {
            ((RedstoneTransmitterTileEntity)srcTE).removeLinkSource(this.f_58858_.m_121996_((Vec3i)worldSrc));
        }
        BlockPos blockPos = this.src = newSrcTE == null ? null : newSrcTE.getTE().m_58899_().m_121996_((Vec3i)this.f_58858_);
        if (newSrcTE instanceof RedstoneTransmitterTileEntity) {
            BlockState srcState = newSrcTE.getTE().m_58900_();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(ESProperties.COLOR, (Comparable)(srcState.m_60734_() == ESBlocks.redstoneTransmitter ? (DyeColor)srcState.m_61143_(ESProperties.COLOR) : DyeColor.WHITE)));
        }
        this.m_6596_();
        this.notifyOutputChange();
    }

    @Override
    public void removeLinkEnd(BlockPos src) {
        this.createLinkEnd(null);
    }

    public void dye(DyeColor color) {
        if (this.f_58857_.m_8055_(this.f_58858_).m_61143_(ESProperties.COLOR) != color) {
            BlockPos worldSrc;
            BlockEntity srcTE;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(ESProperties.COLOR, (Comparable)color));
            if (this.src != null && (srcTE = this.f_58857_.m_7702_(worldSrc = this.f_58858_.m_121955_((Vec3i)this.src))) instanceof RedstoneTransmitterTileEntity) {
                ((RedstoneTransmitterTileEntity)srcTE).dye(color);
            }
        }
    }

    protected void notifyOutputChange() {
        this.f_58857_.m_46672_(this.f_58858_, (Block)ESBlocks.redstoneReceiver);
        for (int i = 0; i < this.dependents.size(); ++i) {
            LazyOptional optional;
            WeakReference<LazyOptional<IRedstoneHandler>> depend = this.dependents.get(i);
            if (depend == null || (optional = (LazyOptional)depend.get()) == null || !optional.isPresent()) {
                this.dependents.remove(i);
                --i;
                continue;
            }
            ((IRedstoneHandler)optional.orElseThrow(NullPointerException::new)).notifyInputChange(this.circRef);
        }
    }

    public void buildDependents() {
        this.dependents.clear();
        for (Direction dir : Direction.values()) {
            LazyOptional otherOpt;
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (te == null || !(otherOpt = te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_())).isPresent()) continue;
            IRedstoneHandler otherHandler = (IRedstoneHandler)otherOpt.orElseThrow(NullPointerException::new);
            otherHandler.findDependents(this.circRef, 0, dir.m_122424_(), dir);
        }
    }

    public float getPower() {
        BlockEntity te;
        if (this.src != null && (te = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)this.src))) instanceof RedstoneTransmitterTileEntity) {
            return ((RedstoneTransmitterTileEntity)te).getOutput();
        }
        return 0.0f;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("src")) {
            this.src = BlockPos.m_122022_((long)nbt.m_128454_("src"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.src != null) {
            nbt.m_128356_("src", this.src.m_121878_());
        }
    }

    @Override
    public BlockEntity getTE() {
        return this;
    }

    @Override
    public boolean canLink(ILinkTE otherTE) {
        return false;
    }

    public HashSet<BlockPos> getLinks() {
        return new HashSet<BlockPos>(1);
    }

    @Override
    public int getMaxLinks() {
        return 0;
    }

    @Override
    public int getRange() {
        return (Integer)ESConfig.wirelessRange.get();
    }

    public void m_7651_() {
        super.m_7651_();
        this.circOpt.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.circOpt;
        }
        return super.getCapability(cap, side);
    }

    private class CircHandler
    implements IRedstoneHandler {
        private CircHandler() {
        }

        @Override
        public float getOutput() {
            return RedstoneReceiverTileEntity.this.getPower();
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            LazyOptional depenOption = (LazyOptional)dependency.get();
            if (depenOption != null && depenOption.isPresent()) {
                IRedstoneHandler depHandler = (IRedstoneHandler)depenOption.orElseThrow(NullPointerException::new);
                depHandler.addSrc(RedstoneReceiverTileEntity.this.circRef, nominalSide);
                if (!RedstoneReceiverTileEntity.this.dependents.contains(dependency)) {
                    RedstoneReceiverTileEntity.this.dependents.add(dependency);
                }
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
            if (!RedstoneReceiverTileEntity.this.dependents.contains(dependent)) {
                RedstoneReceiverTileEntity.this.dependents.add(dependent);
            }
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
        }
    }
}

