/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.ILinkTE;
import com.Da_Technomancer.essentials.api.LinkHelper;
import com.Da_Technomancer.essentials.api.redstone.IWireConnect;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneReceiverTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneReceiver
extends BaseEntityBlock
implements IWireConnect {
    public RedstoneReceiver() {
        super(ESBlocks.getRockProperty());
        String name = "redstone_receiver";
        ESBlocks.queueForRegister(name, this);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ESProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        BlockEntity te = worldIn.m_7702_(pos);
        if (LinkHelper.isLinkTool(heldItem) && te instanceof RedstoneReceiverTileEntity) {
            if (!worldIn.f_46443_) {
                LinkHelper.wrench((ILinkTE)te, heldItem, playerIn);
            }
            return InteractionResult.SUCCESS;
        }
        Item dye = heldItem.m_41720_();
        if (dye instanceof DyeItem && te instanceof RedstoneReceiverTileEntity) {
            if (!worldIn.f_46443_) {
                ((RedstoneReceiverTileEntity)te).dye(((DyeItem)dye).m_41089_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.reds_rec.desc"));
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.reds_rec.linking"));
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.reds_rec.dyes"));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RedstoneReceiverTileEntity(pos, state);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity te = blockAccess.m_7702_(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            return Math.min(Math.round(((RedstoneReceiverTileEntity)te).getPower()), 15);
        }
        return super.m_6378_(blockState, blockAccess, pos, side);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{ESProperties.COLOR});
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        return true;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            ((RedstoneReceiverTileEntity)te).buildDependents();
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof RedstoneReceiverTileEntity) {
            ((RedstoneReceiverTileEntity)te).buildDependents();
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = worldIn.m_7702_(pos)) instanceof RedstoneReceiverTileEntity) {
            ((RedstoneReceiverTileEntity)te).createLinkEnd(null);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

