/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.api.BlockUtil;
import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.packets.IFloatReceiver;
import com.Da_Technomancer.essentials.api.packets.SendFloatToClient;
import com.Da_Technomancer.essentials.api.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.api.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class CircuitTileEntity
extends BlockEntity
implements IFloatReceiver {
    public static final BlockEntityType<CircuitTileEntity> TYPE = ESTileEntity.createType(CircuitTileEntity::new, new Block[]{ESBlocks.andCircuit, ESBlocks.orCircuit, ESBlocks.notCircuit, ESBlocks.xorCircuit, ESBlocks.maxCircuit, ESBlocks.minCircuit, ESBlocks.sumCircuit, ESBlocks.difCircuit, ESBlocks.prodCircuit, ESBlocks.quotCircuit, ESBlocks.powCircuit, ESBlocks.invCircuit, ESBlocks.cosCircuit, ESBlocks.sinCircuit, ESBlocks.tanCircuit, ESBlocks.asinCircuit, ESBlocks.acosCircuit, ESBlocks.atanCircuit, ESBlocks.readerCircuit, ESBlocks.moduloCircuit, ESBlocks.moreCircuit, ESBlocks.lessCircuit, ESBlocks.equalsCircuit, ESBlocks.absCircuit, ESBlocks.signCircuit});
    public boolean builtConnections = false;
    private final ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> dependents = new ArrayList(1);
    private final ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient>> sources = new ArrayList(4);
    private LazyOptional<IRedstoneHandler> hanOptional = LazyOptional.of(() -> new RedsHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> hanReference = new WeakReference<LazyOptional<IRedstoneHandler>>(this.hanOptional);
    private float output = 0.0f;

    public CircuitTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    protected CircuitTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nonnull
    protected AbstractCircuit getOwner() {
        Block b = this.m_58900_().m_60734_();
        if (b instanceof AbstractCircuit) {
            return (AbstractCircuit)b;
        }
        this.m_7651_();
        return ESBlocks.consCircuit;
    }

    private Direction getFacing() {
        BlockState s = this.m_58900_();
        if (s.m_61138_((Property)ESProperties.HORIZ_FACING)) {
            return (Direction)s.m_61143_((Property)ESProperties.HORIZ_FACING);
        }
        this.m_7651_();
        return Direction.NORTH;
    }

    public float getOutput() {
        this.buildConnections();
        return this.output;
    }

    private void setPower(float newPower) {
        if (RedstoneUtil.didChange(this.output, newPower)) {
            Direction facing = this.getFacing();
            if (this.dependents.isEmpty() && RedstoneUtil.clampToVanilla(this.output) != RedstoneUtil.clampToVanilla(newPower)) {
                this.output = newPower;
                AbstractCircuit.strongSignalBlockUpdates(this.f_58857_, this.f_58858_, (Block)this.getOwner(), facing);
            }
            this.output = newPower;
            BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendFloatToClient(0, this.output, this.f_58858_));
            for (int i = 0; i < this.dependents.size(); ++i) {
                IRedstoneHandler handler;
                WeakReference<LazyOptional<IRedstoneHandler>> dependent = this.dependents.get(i);
                if (dependent == null || (handler = (IRedstoneHandler)BlockUtil.get((LazyOptional)dependent.get())) == null) {
                    this.dependents.remove(i);
                    --i;
                    continue;
                }
                handler.notifyInputChange(this.hanReference);
            }
            this.m_6596_();
        }
    }

    protected float[] getInputs(AbstractCircuit owner) {
        this.buildConnections();
        float[] inputs = new float[3];
        boolean[] hasSrc = new boolean[3];
        for (int i = 0; i < this.sources.size(); ++i) {
            IRedstoneHandler handl;
            WeakReference ref;
            Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient> src = this.sources.get(i);
            if (src == null || (ref = (WeakReference)src.getLeft()) == null || (handl = (IRedstoneHandler)BlockUtil.get((LazyOptional)ref.get())) == null) {
                this.sources.remove(i);
                --i;
                continue;
            }
            int ind = ((Orient)((Object)src.getRight())).ordinal();
            if (ind > 2) {
                IndexOutOfBoundsException e = new IndexOutOfBoundsException("Input into redstone device on the front! Pos: " + this.f_58858_ + "; Dim: " + this.f_58857_.m_46472_() + "Type: " + ForgeRegistries.BLOCKS.getKey((Object)this.getOwner()));
                Essentials.logger.catching((Throwable)e);
                this.sources.remove(i);
                --i;
                continue;
            }
            float newInput = RedstoneUtil.sanitize(handl.getOutput());
            inputs[ind] = RedstoneUtil.chooseInput(inputs[ind], newInput);
            hasSrc[ind] = true;
        }
        Direction facing = this.getFacing();
        for (int i = 0; i < 3; ++i) {
            if (hasSrc[i] || !owner.useInput(Orient.values()[i])) continue;
            Direction dir = Orient.values()[i].getFacing(facing);
            inputs[i] = RedstoneUtil.getRedstoneOnSide(this.f_58857_, this.f_58858_, dir);
        }
        return inputs;
    }

    public void recalculateOutput() {
        float newOutput;
        AbstractCircuit owner = this.getOwner();
        float[] inputs = this.getInputs(owner);
        try {
            newOutput = owner.getOutput(inputs[0], inputs[1], inputs[2], this);
        }
        catch (ArithmeticException e) {
            newOutput = 0.0f;
        }
        this.setPower(RedstoneUtil.sanitize(newOutput));
    }

    public void buildConnections() {
        if (!this.builtConnections && !this.f_58857_.f_46443_) {
            IRedstoneHandler otherHandler;
            this.builtConnections = true;
            this.dependents.clear();
            this.sources.clear();
            AbstractCircuit own = this.getOwner();
            Direction dir = this.getFacing();
            for (Orient or : Orient.INPUTS) {
                IRedstoneHandler otherHandler2;
                Direction checkDir;
                BlockEntity te;
                if (!own.useInput(or) || (te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(checkDir = or.getFacing(dir)))) == null || (otherHandler2 = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.m_122424_()))) == null) continue;
                otherHandler2.requestSrc(this.hanReference, 0, checkDir.m_122424_(), checkDir);
            }
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (te != null && (otherHandler = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.m_122424_()))) != null) {
                otherHandler.findDependents(this.hanReference, 0, dir.m_122424_(), dir);
            }
            this.handleInputChange(TickPriority.NORMAL);
        }
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.output = 0.0f;
        this.builtConnections = false;
        this.dependents.clear();
        this.sources.clear();
        this.hanOptional.invalidate();
        this.hanOptional = LazyOptional.of(() -> new RedsHandler());
        this.hanReference = new WeakReference<LazyOptional<IRedstoneHandler>>(this.hanOptional);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendFloatToClient(0, this.output, this.f_58858_));
            this.buildConnections();
            this.m_6596_();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.hanOptional.invalidate();
    }

    @Override
    public void receiveFloat(byte id, float value, @Nullable ServerPlayer sender) {
        if (id == 0 && this.f_58857_.f_46443_) {
            this.output = value;
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.output = nbt.m_128457_("pow");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("pow", this.output);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            Direction dir = this.getFacing();
            if (side == null || side.m_122434_() != Direction.Axis.Y && (dir == side || this.getOwner().useInput(Orient.getOrient(side, dir)))) {
                return this.hanOptional;
            }
        }
        return super.getCapability(cap, side);
    }

    public void handleInputChange(TickPriority priority) {
        this.f_58857_.m_186464_(this.f_58858_, (Block)this.getOwner(), 2, priority);
    }

    public static enum Orient {
        CCW,
        BACK,
        CW,
        FRONT;

        public static final Orient[] INPUTS;

        public static Orient getOrient(Direction dir, Direction front) {
            if (front != null) {
                if (front == dir) {
                    return FRONT;
                }
                if (front.m_122424_() == dir) {
                    return BACK;
                }
                if (front.m_122427_() == dir) {
                    return CW;
                }
                if (front.m_122428_() == dir) {
                    return CCW;
                }
            }
            throw new IllegalArgumentException(String.format("front &/or dir are vertical/null. Front: %s; Dir: %s", front == null ? "NULL" : front.toString(), dir == null ? "NULL" : dir.toString()));
        }

        public Direction getFacing(Direction front) {
            return switch (this) {
                case FRONT -> front;
                case BACK -> front.m_122424_();
                case CW -> front.m_122427_();
                case CCW -> front.m_122428_();
                default -> throw new IllegalStateException("Unhandled Orientation: " + this.name());
            };
        }

        static {
            INPUTS = new Orient[]{CCW, BACK, CW};
        }
    }

    private class RedsHandler
    implements IRedstoneHandler {
        private RedsHandler() {
        }

        @Override
        public float getOutput() {
            return CircuitTileEntity.this.output;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)src.get();
            Orient or = Orient.getOrient(fromSide, CircuitTileEntity.this.getFacing());
            if (CircuitTileEntity.this.getOwner().useInput(or) && srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get(srcOption);
                srcHandler.addDependent(CircuitTileEntity.this.hanReference, nominalSide);
                Pair toAdd = Pair.of(src, (Object)((Object)or));
                if (!CircuitTileEntity.this.sources.contains(toAdd)) {
                    CircuitTileEntity.this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient>)toAdd);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            LazyOptional depenOption;
            if (Orient.getOrient(toSide, CircuitTileEntity.this.getFacing()) == Orient.FRONT && (depenOption = (LazyOptional)dependency.get()) != null && depenOption.isPresent()) {
                IRedstoneHandler depHandler = (IRedstoneHandler)BlockUtil.get(depenOption);
                depHandler.addSrc(CircuitTileEntity.this.hanReference, nominalSide);
                if (!CircuitTileEntity.this.dependents.contains(dependency)) {
                    CircuitTileEntity.this.dependents.add(dependency);
                }
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
            Pair toAdd;
            Orient or = Orient.getOrient(fromSide, CircuitTileEntity.this.getFacing());
            if (or != null && or != Orient.FRONT && CircuitTileEntity.this.getOwner().useInput(or) && !CircuitTileEntity.this.sources.contains(toAdd = Pair.of(src, (Object)((Object)or)))) {
                CircuitTileEntity.this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient>)toAdd);
                this.notifyInputChange(src);
            }
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
            Orient or = Orient.getOrient(toSide, CircuitTileEntity.this.getFacing());
            if (or == Orient.FRONT && !CircuitTileEntity.this.dependents.contains(dependent)) {
                CircuitTileEntity.this.dependents.add(dependent);
            }
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
            CircuitTileEntity.this.handleInputChange(TickPriority.HIGH);
        }
    }
}

