/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.api.ConfigUtil;
import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.blocks.redstone.CircuitTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;

public abstract class AbstractCircuit
extends AbstractTile {
    protected AbstractCircuit(String name) {
        super(name);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ESProperties.HORIZ_FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (ConfigUtil.isWrench(playerIn.m_21120_(hand))) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING)).m_122427_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CircuitTileEntity(pos, state);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity) {
            CircuitTileEntity cte = (CircuitTileEntity)te;
            if (!worldIn.f_46443_) {
                cte.builtConnections = false;
                cte.buildConnections();
                return;
            }
        }
        worldIn.m_186464_(pos, (Block)this, 2, TickPriority.VERY_HIGH);
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity) {
            CircuitTileEntity cte = (CircuitTileEntity)te;
            if (blockIn == Blocks.f_50088_ || blockIn instanceof DiodeBlock) {
                cte.handleInputChange(TickPriority.HIGH);
            } else {
                cte.builtConnections = false;
            }
            cte.buildConnections();
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity te;
        if (side.m_122424_() == state.m_61143_((Property)ESProperties.HORIZ_FACING) && (te = blockAccess.m_7702_(pos)) instanceof CircuitTileEntity) {
            return RedstoneUtil.clampToVanilla(((CircuitTileEntity)te).getOutput());
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.m_6378_(state, world, pos, side);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean p_60519_) {
        AbstractCircuit.strongSignalBlockUpdates(world, pos, (Block)this, (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING));
        super.m_6810_(state, world, pos, newState, p_60519_);
    }

    public static void strongSignalBlockUpdates(Level world, BlockPos pos, Block block, Direction facing) {
        Direction reverseDir = facing.m_122424_();
        BlockPos offsetPos = pos.m_121945_(facing);
        world.m_46586_(offsetPos, block, pos.m_121945_(reverseDir));
        world.m_46590_(offsetPos, block, reverseDir);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return side != null && (side.m_122424_() == state.m_61143_((Property)ESProperties.HORIZ_FACING) || this.useInput(CircuitTileEntity.Orient.getOrient(side.m_122424_(), (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING))));
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity) {
            ((CircuitTileEntity)te).recalculateOutput();
        }
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING);
        return side == facing || this.useInput(CircuitTileEntity.Orient.getOrient(side, facing));
    }

    @Override
    public boolean usesQuartz() {
        return true;
    }

    public abstract boolean useInput(CircuitTileEntity.Orient var1);

    public abstract float getOutput(float var1, float var2, float var3, CircuitTileEntity var4);
}

