/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.api.ConfigUtil;
import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class WitherCannon
extends Block {
    protected WitherCannon() {
        super(ESBlocks.getRockProperty().m_60913_(50.0f, 1200.0f));
        String name = "wither_cannon";
        ESBlocks.queueForRegister(name, this);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ESProperties.FACING, (Comparable)context.m_7820_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ESProperties.FACING}).m_61104_(new Property[]{ESProperties.REDSTONE_BOOL});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (ConfigUtil.isWrench(playerIn.m_21120_(hand))) {
            if (!worldIn.f_46443_) {
                BlockState endState = (BlockState)state.m_61122_((Property)ESProperties.FACING);
                worldIn.m_46597_(pos, endState);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)"tt.essentials.wither_cannon"));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos srcPos, boolean flag) {
        boolean powered = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        boolean wasActive = (Boolean)state.m_61143_((Property)ESProperties.REDSTONE_BOOL);
        if (powered && !wasActive) {
            world.m_186460_(pos, (Block)this, 4);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!powered && wasActive) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ESProperties.REDSTONE_BOOL, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        Direction dir = (Direction)state.m_61143_((Property)ESProperties.FACING);
        BlockPos spawnPos = pos.m_121945_(dir);
        CannonSkull skull = new CannonSkull(CannonSkull.ENT_TYPE, (Level)world);
        skull.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.5, (double)spawnPos.m_123343_() + 0.5, dir.m_122435_() + 180.0f, dir.m_122430_() * -90);
        skull.m_20334_((float)dir.m_122429_() / 5.0f, (float)dir.m_122430_() / 5.0f, (float)dir.m_122431_() / 5.0f);
        skull.f_36813_ = (double)dir.m_122429_() / 20.0;
        skull.f_36814_ = (double)dir.m_122430_() / 20.0;
        skull.f_36815_ = (double)dir.m_122431_() / 20.0;
        world.m_7967_((Entity)skull);
    }

    public static class CannonSkull
    extends WitherSkull {
        public static final EntityType<CannonSkull> ENT_TYPE = EntityType.Builder.m_20704_(CannonSkull::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).m_20699_(0.3125f, 0.3125f).m_20719_().setUpdateInterval(4).setTrackingRange(4).setCustomClientFactory((s, w) -> new CannonSkull(ENT_TYPE, (Level)w)).m_20712_("cannon_skull");
        private int lifespan = 60;

        public CannonSkull(EntityType<CannonSkull> type, Level world) {
            super(type, world);
        }

        public void m_8119_() {
            super.m_8119_();
            if (!this.m_9236_().f_46443_ && this.lifespan-- <= 0) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }

        public void m_7380_(CompoundTag nbt) {
            super.m_7380_(nbt);
            nbt.m_128405_("lifetime", this.lifespan);
        }

        public void m_7378_(CompoundTag nbt) {
            super.m_7378_(nbt);
            this.lifespan = nbt.m_128451_("lifetime");
        }

        protected void m_6532_(HitResult result) {
            if (!this.m_9236_().f_46443_) {
                if (result.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)result).m_82443_();
                    entity.m_6469_(this.m_269291_().m_269425_(), 5.0f);
                    if (entity instanceof LivingEntity) {
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                    }
                }
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.TNT);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }

        public Packet<ClientGamePacketListener> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }
    }
}

