/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.api.BlockUtil;
import com.Da_Technomancer.essentials.api.ITickableTileEntity;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.blocks.HopperFilterTileEntity;
import com.Da_Technomancer.essentials.blocks.SortingHopper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SortingHopperTileEntity
extends BlockEntity
implements ITickableTileEntity,
Container,
MenuProvider {
    public static final BlockEntityType<SortingHopperTileEntity> TYPE = ESTileEntity.createType(SortingHopperTileEntity::new, new Block[]{ESBlocks.sortingHopper});
    protected final ItemStack[] inventory = new ItemStack[5];
    private int transferCooldown = -1;
    private Direction dir = null;
    protected ItemHandler handler = new ItemHandler();

    protected SortingHopperTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.f_41583_;
        }
    }

    public SortingHopperTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    public void resetCache() {
        this.dir = null;
    }

    protected Direction getDir() {
        if (this.dir == null) {
            BlockState state = this.m_58900_();
            if (!(state.m_60734_() instanceof SortingHopper)) {
                return Direction.DOWN;
            }
            this.dir = (Direction)state.m_61143_((Property)SortingHopper.FACING);
        }
        return this.dir;
    }

    @Override
    public void serverTick() {
        if (--this.transferCooldown <= 0) {
            this.transferCooldown = 0;
            BlockState state = this.m_58900_();
            if (state.m_60734_() instanceof SortingHopper && ((Boolean)state.m_61143_((Property)SortingHopper.ENABLED)).booleanValue()) {
                boolean flag = false;
                if (!this.isFull()) {
                    flag = this.transferItemsIn();
                }
                if (!this.m_7983_()) {
                    boolean bl = flag = this.transferItemsOut() || flag;
                }
                if (flag) {
                    this.transferCooldown = 8;
                    this.m_6596_();
                }
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.transferCooldown = nbt.m_128451_("trans_cooldown");
        for (int i = 0; i < 5; ++i) {
            CompoundTag stackNBT = nbt.m_128469_("inv_" + i);
            this.inventory[i] = ItemStack.m_41712_((CompoundTag)stackNBT);
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int i = 0; i < 5; ++i) {
            if (this.inventory[i].m_41619_()) continue;
            CompoundTag stackNBT = new CompoundTag();
            this.inventory[i].m_41739_(stackNBT);
            nbt.m_128365_("inv_" + i, (Tag)stackNBT);
        }
        nbt.m_128405_("trans_cooldown", this.transferCooldown);
    }

    public int m_6643_() {
        return 5;
    }

    public ItemStack m_8020_(int index) {
        return index > 4 ? ItemStack.f_41583_ : this.inventory[index];
    }

    public ItemStack m_7407_(int index, int count) {
        if (index > 4 || this.inventory[index].m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.m_6596_();
        return this.inventory[index].m_41620_(count);
    }

    public ItemStack m_8016_(int index) {
        if (index > 4) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = this.inventory[index];
        this.inventory[index] = ItemStack.f_41583_;
        this.m_6596_();
        return copy;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index > 4) {
            return;
        }
        this.inventory[index] = stack;
        this.m_6596_();
        if (!stack.m_41619_() && stack.m_41613_() > stack.m_41741_()) {
            stack.m_41764_(stack.m_41741_());
        }
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_)) <= 64.0;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index < 5;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    protected int transferQuantity() {
        return 1;
    }

    protected boolean transferItemsOut() {
        Direction facing = this.getDir();
        IItemHandler otherHandler = SortingHopperTileEntity.getHandlerAtPosition(this.f_58857_, this.f_58858_.m_121945_(facing), facing.m_122424_(), null);
        if (otherHandler != null) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                ItemStack stackInSlot = this.m_8020_(i);
                if (stackInSlot.m_41619_()) continue;
                ItemStack insert = stackInSlot.m_41777_();
                insert.m_41764_(Math.min(insert.m_41613_(), this.transferQuantity()));
                ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)insert, (boolean)true);
                if (newStack.m_41613_() >= insert.m_41613_()) continue;
                insert.m_41764_(insert.m_41613_() - newStack.m_41613_());
                newStack = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)insert, (boolean)false);
                if (!this.m_7407_(i, insert.m_41613_() - newStack.m_41613_()).m_41619_()) {
                    this.m_6596_();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean transferItemsIn() {
        BlockEntity aboveTE;
        BlockPos upPos = this.f_58858_.m_7494_();
        IItemHandler otherHandler = SortingHopperTileEntity.getHandlerAtPosition(this.f_58857_, upPos, Direction.DOWN, aboveTE = this.f_58857_.m_7702_(upPos));
        if (otherHandler != null) {
            for (int i = 0; i < otherHandler.getSlots(); ++i) {
                ItemStack extractItem = otherHandler.extractItem(i, this.transferQuantity(), true);
                if (extractItem.m_41619_()) continue;
                for (int j = 0; j < this.m_6643_(); ++j) {
                    ItemStack uninserted = this.handler.insertItem(j, extractItem, false);
                    if (uninserted.m_41613_() >= extractItem.m_41613_()) continue;
                    otherHandler.extractItem(i, extractItem.m_41613_() - uninserted.m_41613_(), false);
                    return true;
                }
            }
            return false;
        }
        boolean changed = false;
        List itemEntities = aboveTE instanceof HopperFilterTileEntity ? this.f_58857_.m_6443_(ItemEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)this.f_58858_.m_123342_() + 3.0, (double)(this.f_58858_.m_123343_() + 1)), entity -> entity.m_6084_() && ((HopperFilterTileEntity)aboveTE).matchFilter(entity.m_32055_())) : this.f_58857_.m_6443_(ItemEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)this.f_58858_.m_123342_() + 2.0, (double)(this.f_58858_.m_123343_() + 1)), EntitySelector.f_20402_);
        for (ItemEntity entityitem : itemEntities) {
            ItemStack stack;
            if (entityitem == null) continue;
            ItemStack remain = stack = entityitem.m_32055_().m_41777_();
            for (int i = 0; i < 5 && !(remain = this.handler.insertItem(i, remain, false)).m_41619_(); ++i) {
            }
            if (remain.m_41619_()) {
                entityitem.m_142687_(Entity.RemovalReason.DISCARDED);
                changed = true;
                continue;
            }
            if (remain.m_41613_() == stack.m_41613_()) continue;
            entityitem.m_146870_();
            changed = true;
        }
        return changed;
    }

    public static IItemHandler getHandlerAtPosition(Level world, BlockPos otherPos, Direction direction, @Nullable BlockEntity cacheTE) {
        IItemHandler handler;
        LazyOptional capability;
        BlockEntity te;
        BlockEntity blockEntity = te = cacheTE == null ? world.m_7702_(otherPos) : cacheTE;
        if (te != null && (capability = te.getCapability(ForgeCapabilities.ITEM_HANDLER, direction)).isPresent() && (handler = (IItemHandler)capability.orElseThrow(NullPointerException::new)).getSlots() > 0) {
            return handler;
        }
        BlockState state = world.m_8055_(otherPos);
        if (state.m_60734_() instanceof WorldlyContainerHolder) {
            WorldlyContainer inv = ((WorldlyContainerHolder)state.m_60734_()).m_5840_(state, (LevelAccessor)world, otherPos);
            return new WorldlyInvWrapper((Container)inv, direction);
        }
        List list = world.m_6249_((Entity)null, new AABB(otherPos), EntitySelector.f_20405_);
        if (!list.isEmpty()) {
            return new InvWrapper((Container)list.get(world.f_46441_.m_188503_(list.size())));
        }
        return null;
    }

    protected static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return BlockUtil.sameItem(stack1, stack2) && stack1.m_41613_() <= stack1.m_41741_();
    }

    public void m_6211_() {
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.f_41583_;
        }
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.handler);
        }
        return super.getCapability(capability, facing);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.sorting_hopper");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new HopperMenu(id, playerInventory, (Container)this);
    }

    protected class ItemHandler
    implements IItemHandler {
        protected ItemHandler() {
        }

        public int getSlots() {
            return SortingHopperTileEntity.this.m_6643_();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return SortingHopperTileEntity.this.m_8020_(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41619_() || slot > 4) {
                return ItemStack.f_41583_;
            }
            if (SortingHopperTileEntity.this.inventory[slot].m_41619_() || SortingHopperTileEntity.canCombine(stack, SortingHopperTileEntity.this.inventory[slot])) {
                int moved = Math.min(stack.m_41613_(), stack.m_41741_() - SortingHopperTileEntity.this.inventory[slot].m_41613_());
                ItemStack remain = stack.m_41777_();
                remain.m_41774_(moved);
                if (!simulate && moved != 0) {
                    if (SortingHopperTileEntity.this.inventory[slot].m_41619_()) {
                        SortingHopperTileEntity.this.inventory[slot] = stack.m_41777_();
                        SortingHopperTileEntity.this.inventory[slot].m_41764_(moved);
                    } else {
                        SortingHopperTileEntity.this.inventory[slot].m_41769_(moved);
                    }
                    if (SortingHopperTileEntity.this.transferCooldown < 1) {
                        SortingHopperTileEntity.this.transferCooldown = 8;
                    }
                    SortingHopperTileEntity.this.m_6596_();
                }
                return remain;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            LazyOptional otherCap;
            if (amount <= 0 || slot > 4) {
                return ItemStack.f_41583_;
            }
            Direction facing = SortingHopperTileEntity.this.getDir();
            BlockEntity te = SortingHopperTileEntity.this.f_58857_.m_7702_(SortingHopperTileEntity.this.f_58858_.m_121945_(facing));
            if (te != null && (otherCap = te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_())).isPresent()) {
                IItemHandler otherHandler = (IItemHandler)otherCap.orElseThrow(NullPointerException::new);
                int slots = otherHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    if (otherHandler.insertItem(i, SortingHopperTileEntity.this.inventory[slot], true).m_41613_() >= SortingHopperTileEntity.this.inventory[slot].m_41613_()) continue;
                    return ItemStack.f_41583_;
                }
            }
            int removed = Math.min(amount, SortingHopperTileEntity.this.inventory[slot].m_41613_());
            if (!simulate) {
                SortingHopperTileEntity.this.m_6596_();
                return SortingHopperTileEntity.this.inventory[slot].m_41620_(removed);
            }
            ItemStack out = SortingHopperTileEntity.this.inventory[slot].m_41777_();
            out.m_41764_(removed);
            return out;
        }

        public int getSlotLimit(int slot) {
            return SortingHopperTileEntity.this.m_6893_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }

    private static class WorldlyInvWrapper
    extends InvWrapper {
        private final Direction direction;

        public WorldlyInvWrapper(Container inv, Direction accessDirection) {
            super(inv);
            this.direction = accessDirection;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            WorldlyContainer wInv;
            Container container = this.getInv();
            if (container instanceof WorldlyContainer && !(wInv = (WorldlyContainer)container).m_7155_(slot, stack, this.direction)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            WorldlyContainer wInv;
            Container container = this.getInv();
            if (container instanceof WorldlyContainer && !(wInv = (WorldlyContainer)container).m_7157_(slot, wInv.m_8020_(slot), this.direction)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

