/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.api.BlockUtil;
import com.Da_Technomancer.essentials.api.IItemContainer;
import com.Da_Technomancer.essentials.api.packets.INBTReceiver;
import com.Da_Technomancer.essentials.api.packets.SendNBTToClient;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.gui.container.SlottedChestContainer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class SlottedChestTileEntity
extends BlockEntity
implements INBTReceiver,
MenuProvider,
IItemContainer {
    public static final BlockEntityType<SlottedChestTileEntity> TYPE = ESTileEntity.createType(SlottedChestTileEntity::new, new Block[]{ESBlocks.slottedChest});
    private final ItemStack[] inv = new ItemStack[54];
    public ItemStack[] lockedInv = new ItemStack[this.inv.length];
    private final LazyOptional<IItemHandler> invOptional = LazyOptional.of(() -> new InventoryHandler());

    public SlottedChestTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        Arrays.fill(this.inv, ItemStack.f_41583_);
        Arrays.fill(this.lockedInv, ItemStack.f_41583_);
    }

    public float calcComparator() {
        float f = 0.0f;
        for (ItemStack itemstack : this.inv) {
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(64, itemstack.m_41741_());
        }
        return f /= (float)this.inv.length;
    }

    private void updateFilter() {
        boolean syncToClient = !this.f_58857_.f_46443_;
        CompoundTag slotNBT = new CompoundTag();
        for (int i = 0; i < this.inv.length; ++i) {
            if (!this.inv[i].m_41619_() && !BlockUtil.sameItem(this.inv[i], this.lockedInv[i])) {
                this.lockedInv[i] = this.inv[i].m_41777_();
                this.lockedInv[i].m_41764_(1);
            }
            if (!syncToClient || this.lockedInv[i].m_41619_()) continue;
            slotNBT.m_128365_("lock" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
        if (syncToClient) {
            BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendNBTToClient(slotNBT, this.f_58858_));
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = nbt.m_128441_("slot" + i) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("slot" + i)) : ItemStack.f_41583_;
            if (nbt.m_128441_("lockSlot" + i)) {
                this.lockedInv[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lockSlot" + i));
                continue;
            }
            this.inv[i] = ItemStack.f_41583_;
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int i = 0; i < this.inv.length; ++i) {
            if (!this.inv[i].m_41619_()) {
                nbt.m_128365_("slot" + i, (Tag)this.inv[i].m_41739_(new CompoundTag()));
            }
            if (this.lockedInv[i].m_41619_()) continue;
            nbt.m_128365_("lockSlot" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.lockedInv[i].m_41619_()) continue;
            nbt.m_128365_("lockSlot" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
        return nbt;
    }

    public void m_7651_() {
        super.m_7651_();
        this.invOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.invOptional;
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        for (int i = 0; i < this.inv.length; ++i) {
            this.lockedInv[i] = nbt.m_128441_("lock" + i) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lock" + i)) : ItemStack.f_41583_;
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.slotted_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        FriendlyByteBuf buf = this.createContainerBuf();
        for (ItemStack lock : this.lockedInv) {
            buf.m_130055_(lock);
        }
        return new SlottedChestContainer(id, playerInventory, buf);
    }

    public int[] m_7071_(Direction dir) {
        int[] out = new int[this.inv.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = i;
        }
        return out;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction dir) {
        return index >= 0 && index < this.inv.length;
    }

    public int m_6643_() {
        return this.inv.length;
    }

    public ItemStack m_8020_(int index) {
        return index >= this.inv.length ? ItemStack.f_41583_ : this.inv[index];
    }

    public ItemStack m_7407_(int index, int count) {
        if (index >= this.inv.length || this.inv[index].m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.m_6596_();
        return this.inv[index].m_41620_(count);
    }

    public ItemStack m_8016_(int index) {
        if (index >= this.inv.length) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.inv[index].m_41777_();
        this.inv[index].m_41764_(0);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index < this.inv.length) {
            this.m_6596_();
            this.inv[index] = stack;
            if (!stack.m_41619_()) {
                this.lockedInv[index] = stack.m_41777_();
                this.lockedInv[index].m_41764_(1);
            }
        }
    }

    public void m_6596_() {
        this.updateFilter();
        super.m_6596_();
    }

    public boolean m_6542_(Player playerEntity) {
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index < this.inv.length && BlockUtil.sameItem(stack, this.lockedInv[index]);
    }

    public boolean canPlaceItemUI(int index, ItemStack stack) {
        return index < this.inv.length && (BlockUtil.sameItem(stack, this.lockedInv[index]) || this.lockedInv[index].m_41619_());
    }

    public void m_6211_() {
        Arrays.fill(this.inv, ItemStack.f_41583_);
        Arrays.fill(this.lockedInv, ItemStack.f_41583_);
        this.m_6596_();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.inv) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return SlottedChestTileEntity.this.inv.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return SlottedChestTileEntity.this.m_8020_(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack) || stack.m_41619_() || !SlottedChestTileEntity.this.inv[slot].m_41619_() && !BlockUtil.sameItem(stack, SlottedChestTileEntity.this.inv[slot])) {
                return stack;
            }
            int change = Math.min(stack.m_41741_() - SlottedChestTileEntity.this.inv[slot].m_41613_(), stack.m_41613_());
            if (!simulate) {
                if (SlottedChestTileEntity.this.inv[slot].m_41619_()) {
                    SlottedChestTileEntity.this.inv[slot] = stack.m_41777_();
                } else {
                    SlottedChestTileEntity.this.inv[slot].m_41769_(change);
                }
                SlottedChestTileEntity.this.m_6596_();
            }
            ItemStack out = stack.m_41777_();
            out.m_41774_(change);
            return stack.m_41613_() == change ? ItemStack.f_41583_ : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= SlottedChestTileEntity.this.inv.length || SlottedChestTileEntity.this.inv[slot].m_41619_()) {
                return ItemStack.f_41583_;
            }
            int change = Math.min(SlottedChestTileEntity.this.inv[slot].m_41613_(), amount);
            ItemStack out = SlottedChestTileEntity.this.inv[slot].m_41777_();
            out.m_41764_(change);
            if (!simulate) {
                SlottedChestTileEntity.this.inv[slot].m_41774_(change);
                SlottedChestTileEntity.this.m_6596_();
            }
            return change == 0 ? ItemStack.f_41583_ : out;
        }

        public int getSlotLimit(int slot) {
            return SlottedChestTileEntity.this.getMaxStackSize(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return SlottedChestTileEntity.this.m_7013_(slot, stack);
        }
    }
}

